/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.data.beans.portlets;

import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.pluto.container.PortletWindow;
import org.jahia.data.applications.EntryPointDefinition;
import org.jahia.data.applications.EntryPointInstance;
import org.jahia.data.beans.portlets.PortletModeBean;
import org.jahia.data.beans.portlets.WindowStateBean;
import org.jahia.services.usermanager.JahiaUser;

public class PortletWindowBean {
    private int ID;
    private EntryPointInstance entryPointInstance;
    private JahiaUser jahiaUser;
    private HttpServletRequest httpServletRequest;
    private EntryPointDefinition entryPointDefinition;
    private PortletWindow portletWindow;

    public PortletWindowBean() {
    }

    public PortletWindowBean(JahiaUser jahiaUser, HttpServletRequest httpServletRequest, PortletWindow portletWindow) {
        this.jahiaUser = jahiaUser;
        this.httpServletRequest = httpServletRequest;
        this.portletWindow = portletWindow;
    }

    public int getID() {
        return this.ID;
    }

    public void setID(int ID) {
        this.ID = ID;
    }

    public String getEntryPointInstanceID() {
        return this.entryPointInstance.getID();
    }

    public List<PortletModeBean> getPortletModeBeans(String workspaceName) {
        ArrayList<PortletModeBean> portletModeBeans = new ArrayList<PortletModeBean>();
        if (this.entryPointDefinition != null) {
            for (PortletMode curPortletMode : this.entryPointDefinition.getPortletModes()) {
                String modeName = curPortletMode.toString();
                if (modeName == null || !this.entryPointInstance.isModeAllowed(this.jahiaUser, modeName, workspaceName)) continue;
                PortletModeBean curPortletModeBean = new PortletModeBean(this.httpServletRequest, this);
                curPortletModeBean.setName(modeName);
                portletModeBeans.add(curPortletModeBean);
            }
        }
        return portletModeBeans;
    }

    public List<WindowStateBean> getWindowStateBeans() {
        ArrayList<WindowStateBean> windowStateBeans = new ArrayList<WindowStateBean>();
        if (this.entryPointDefinition != null) {
            for (WindowState curWindowState : this.entryPointDefinition.getWindowStates()) {
                WindowStateBean curWindowStateBean = new WindowStateBean(this.httpServletRequest, this);
                curWindowStateBean.setName(curWindowState.toString());
                windowStateBeans.add(curWindowStateBean);
            }
        }
        return windowStateBeans;
    }

    public PortletModeBean getCurrentPortletModeBean() {
        PortletModeBean portletModeBean = new PortletModeBean(this.httpServletRequest, this);
        portletModeBean.setName(this.portletWindow.getPortletMode().toString());
        return portletModeBean;
    }

    public WindowStateBean getCurrentWindowStateBean() {
        WindowStateBean currentWindowStateBean = new WindowStateBean(this.httpServletRequest, this);
        currentWindowStateBean.setName(this.portletWindow.getWindowState().toString());
        return currentWindowStateBean;
    }

    public EntryPointInstance getEntryPointInstance() {
        return this.entryPointInstance;
    }

    public void setEntryPointInstance(EntryPointInstance entryPointInstance) {
        this.entryPointInstance = entryPointInstance;
    }

    public EntryPointDefinition getEntryPointDefinition() {
        return this.entryPointDefinition;
    }

    public void setEntryPointDefinition(EntryPointDefinition entryPointDefinition) {
        this.entryPointDefinition = entryPointDefinition;
    }

    public PortletWindow getPortletWindow() {
        return this.portletWindow;
    }
}

