/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.errors;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="SafeExtendedThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"sxEx", "sxThrowable", "sxException"})
public final class SafeExtendedThrowablePatternConverter
extends ThrowablePatternConverter {
    private static final String STACKTRACE_LINE_START = "\n\tat";
    private static final String NESTED_STACKTRACE_LINE_START = "\n\t\tat";

    private SafeExtendedThrowablePatternConverter(Configuration config, String[] options) {
        super("SafeExtendedThrowable", "throwable", options, config);
    }

    public static SafeExtendedThrowablePatternConverter newInstance(Configuration config, String[] options) {
        return new SafeExtendedThrowablePatternConverter(config, options);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        ThrowableProxy proxy = event.getThrownProxy();
        Throwable throwable = event.getThrown();
        if ((throwable != null || proxy != null) && this.options.anyLines()) {
            if (proxy == null) {
                super.format(event, toAppendTo);
                return;
            }
            String suffix = this.getSuffix(event);
            String extStackTrace = proxy.getExtendedStackTraceAsString(this.options.getIgnorePackages(), this.options.getTextRenderer(), suffix);
            int len = toAppendTo.length();
            if (len > 0 && !Character.isWhitespace(toAppendTo.charAt(len - 1))) {
                toAppendTo.append(' ');
            }
            this.appendExtendedStackTrace(toAppendTo, extStackTrace);
        }
    }

    private void appendExtendedStackTrace(StringBuilder toAppendTo, String extStackTrace) {
        if (!this.options.allLines() || !Strings.LINE_SEPARATOR.equals(this.options.getSeparator())) {
            toAppendTo.append(this.replaceLineSeparator(extStackTrace));
        } else {
            int firstMessageWithCRLFIndex = this.indexOfMessageWithCRLF(extStackTrace);
            if (firstMessageWithCRLFIndex != -1) {
                toAppendTo.append(this.replaceLineSeparatorInMessages(extStackTrace, firstMessageWithCRLFIndex));
            } else {
                toAppendTo.append(extStackTrace);
            }
        }
    }

    private String replaceLineSeparator(String extStackTrace) {
        Object[] array = extStackTrace.split(Strings.LINE_SEPARATOR);
        return StringUtils.join((Object[])array, (String)this.options.getSeparator(), (int)0, (int)this.options.minLines(array.length));
    }

    private int indexOfMessageWithCRLF(String extStackTrace) {
        int stackTraceStartIndex;
        int messageStartIndex = 0;
        do {
            if ((stackTraceStartIndex = this.getNextIndex(extStackTrace.indexOf(STACKTRACE_LINE_START, messageStartIndex), extStackTrace.indexOf(NESTED_STACKTRACE_LINE_START, messageStartIndex))) == -1) continue;
            if (StringUtils.lastIndexOf((CharSequence)extStackTrace, (int)13, (int)(--stackTraceStartIndex)) >= messageStartIndex || StringUtils.lastIndexOf((CharSequence)extStackTrace, (int)10, (int)stackTraceStartIndex) >= messageStartIndex) {
                return messageStartIndex;
            }
            if (stackTraceStartIndex == -1) continue;
            messageStartIndex = this.getNextNestedMessageIndex(extStackTrace, stackTraceStartIndex);
        } while (messageStartIndex != -1 && stackTraceStartIndex != -1);
        return -1;
    }

    private int getNextNestedMessageIndex(String extStackTrace, int stackTraceStartIndex) {
        return this.getNextIndex(extStackTrace.indexOf("Caused by:", stackTraceStartIndex), extStackTrace.indexOf("Suppressed:", stackTraceStartIndex));
    }

    private int getNextNestedMessageIndex(StringBuilder extStackTrace, int stackTraceStartIndex) {
        return this.getNextIndex(extStackTrace.indexOf("Caused by:", stackTraceStartIndex), extStackTrace.indexOf("Suppressed:", stackTraceStartIndex));
    }

    private int getNextIndex(int firstIndex, int secondIndex) {
        if (secondIndex == -1) {
            return firstIndex;
        }
        if (firstIndex == -1) {
            return secondIndex;
        }
        return Math.min(firstIndex, secondIndex);
    }

    private String replaceLineSeparatorInMessages(String extStackTrace, int messageWithCRLFIndex) {
        int beginningOfStackTrace;
        StringBuilder sb = new StringBuilder(extStackTrace);
        do {
            beginningOfStackTrace = this.getNextIndex(sb.indexOf(STACKTRACE_LINE_START, messageWithCRLFIndex), sb.indexOf(NESTED_STACKTRACE_LINE_START, messageWithCRLFIndex));
            this.replaceCRLF(sb, messageWithCRLFIndex, beginningOfStackTrace);
        } while ((messageWithCRLFIndex = this.indexOfNestedExceptionMessageWithCRLF(sb, beginningOfStackTrace)) != -1);
        return sb.toString();
    }

    private int indexOfNestedExceptionMessageWithCRLF(StringBuilder extStackTrace, int startIndex) {
        int stackTraceStartIndex;
        do {
            if ((startIndex = this.getNextNestedMessageIndex(extStackTrace, startIndex)) == -1) {
                return startIndex;
            }
            stackTraceStartIndex = this.getNextIndex(extStackTrace.indexOf(STACKTRACE_LINE_START, startIndex), extStackTrace.indexOf(NESTED_STACKTRACE_LINE_START, startIndex));
            if (stackTraceStartIndex == -1 || StringUtils.lastIndexOf((CharSequence)extStackTrace, (int)13, (int)(--stackTraceStartIndex)) < startIndex && StringUtils.lastIndexOf((CharSequence)extStackTrace, (int)10, (int)stackTraceStartIndex) < startIndex) continue;
            return startIndex;
        } while ((startIndex = stackTraceStartIndex) != -1 && stackTraceStartIndex != -1);
        return -1;
    }

    private StringBuilder replaceCRLF(StringBuilder toAppendTo, int start, int end) {
        block4: for (int i = end - 1; i >= start; --i) {
            char c = toAppendTo.charAt(i);
            switch (c) {
                case '\r': {
                    toAppendTo.setCharAt(i, '\\');
                    toAppendTo.insert(i + 1, 'r');
                    continue block4;
                }
                case '\n': {
                    toAppendTo.setCharAt(i, '\\');
                    toAppendTo.insert(i + 1, 'n');
                    continue block4;
                }
            }
        }
        return toAppendTo;
    }
}

