/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.errors;

import java.io.IOException;
import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.jahia.bin.errors.ErrorFileDumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(name="ExceptionAppender", category="Core", elementType="appender", printObject=true)
public class ExceptionAppender
extends AbstractAppender {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionAppender.class);
    private boolean alreadyDumping = false;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private ExceptionAppender(String name, Layout<? extends Serializable> layout, Filter filter) {
        super(name, filter, layout, false, Property.EMPTY_ARRAY);
    }

    public void append(LogEvent event) {
        if (this.alreadyDumping || event.getThrown() == null || ErrorFileDumper.isShutdown()) {
            return;
        }
        try {
            this.alreadyDumping = true;
            ErrorFileDumper.dumpToFile(event.getThrown(), null);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.alreadyDumping = false;
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<ExceptionAppender> {
        public ExceptionAppender build() {
            return new ExceptionAppender(this.getName(), this.getLayout(), this.getFilter());
        }
    }
}

