/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import org.jahia.bin.SessionNamedDataStorage;
import org.jahia.bin.SessionNamedDataStorageSupport;

public class SessionNamedDataStorageInMemory<T>
extends SessionNamedDataStorageSupport<T>
implements SessionNamedDataStorage<T> {
    private ConcurrentHashMap<String, ConcurrentHashMap<String, T>> sessionByID = new ConcurrentHashMap();

    @Override
    public void put(String sessionID, String name, T data) {
        ConcurrentHashMap newDataByName = new ConcurrentHashMap();
        ConcurrentHashMap<String, T> dataByName = this.sessionByID.putIfAbsent(sessionID, newDataByName);
        if (dataByName == null) {
            dataByName = newDataByName;
        }
        dataByName.put(name, data);
    }

    @Override
    public T get(String sessionID, String name) {
        ConcurrentHashMap<String, T> dataByName = this.sessionByID.get(sessionID);
        if (dataByName == null) {
            return null;
        }
        return dataByName.get(name);
    }

    @Override
    public T getRequired(String sessionID, String name) {
        T data = this.get(sessionID, name);
        if (data == null) {
            throw new IllegalArgumentException(MessageFormat.format("No session data found, session ID: {0}, name: {1}", sessionID, name));
        }
        return data;
    }

    @Override
    public void remove(String sessionID, String name) {
        ConcurrentHashMap<String, T> dataByName = this.sessionByID.get(sessionID);
        if (dataByName == null || dataByName.remove(name) == null) {
            throw new IllegalArgumentException(MessageFormat.format("No session data found, session ID: {0}, name: {1}", sessionID, name));
        }
    }

    @Override
    public void removeIfExists(String sessionID) {
        this.sessionByID.remove(sessionID);
    }
}

