/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LimitTokenCountAnalyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.Version;
import org.jahia.utils.LuceneUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaExtendedSpellChecker
implements Closeable {
    public static final String F_WORD = "word";
    public static final String F_LANGUAGE = "language".intern();
    public static final String F_SITE = "site".intern();
    private static final String F_WORD_INTERNED = "word".intern();
    private static final Logger logger = LoggerFactory.getLogger(JahiaExtendedSpellChecker.class);
    Directory spellIndex;
    private float bStart = 2.0f;
    private float bEnd = 1.0f;
    private IndexSearcher searcher;
    private final Object searcherLock = new Object();
    private final Object modifyCurrentIndexLock = new Object();
    private volatile boolean closed = false;
    private float minScore = 0.5f;
    private StringDistance sd;

    public JahiaExtendedSpellChecker(Directory spellIndex, StringDistance sd) throws IOException {
        this.setSpellIndex(spellIndex);
        this.setStringDistance(sd);
    }

    public JahiaExtendedSpellChecker(Directory spellIndex) throws IOException {
        this(spellIndex, (StringDistance)new LevensteinDistance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpellIndex(Directory spellIndexDir) throws IOException {
        Object object = this.modifyCurrentIndexLock;
        synchronized (object) {
            this.ensureOpen();
            if (!IndexReader.indexExists((Directory)spellIndexDir)) {
                this.createIndexWriter(spellIndexDir);
            }
            this.swapSearcher(spellIndexDir);
        }
    }

    private void createIndexWriter(Directory spellIndexDir) throws IOException {
        IndexWriter writer = new IndexWriter(spellIndexDir, new IndexWriterConfig(Version.LUCENE_36, (Analyzer)new LimitTokenCountAnalyzer(null, Integer.MAX_VALUE)).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        writer.close();
    }

    public void setStringDistance(StringDistance sd) {
        this.sd = sd;
    }

    public StringDistance getStringDistance() {
        return this.sd;
    }

    public void setAccuracy(float minScore) {
        this.minScore = minScore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] suggestSimilar(String word, int numSug, IndexReader ir, boolean morePopular, String[] sites, String language) throws IOException {
        long startTime = System.currentTimeMillis();
        IndexSearcher indexSearcher = this.obtainSearcher();
        try {
            int goalFreq;
            float min = this.minScore;
            int lengthWord = word.length();
            List<String> fields = this.getFields(sites, language);
            int freq = 0;
            for (String string : fields) {
                freq += ir != null ? ir.docFreq(new Term(string, word)) : 0;
            }
            int n = goalFreq = morePopular && ir != null ? freq : 0;
            if (!morePopular && freq > 0) {
                String[] stringArray = new String[]{word};
                return stringArray;
            }
            BooleanQuery booleanQuery = this.getClauses(word, sites, language, lengthWord);
            int maxHits = 10 * numSug;
            SuggestWordQueue sugQueue = new SuggestWordQueue(numSug);
            ScoreDoc[] hits = indexSearcher.search((Query)booleanQuery, (int)maxHits).scoreDocs;
            int stop = hits == null ? 0 : Math.min(hits.length, 10 * numSug);
            this.getSuggestionWords(word, numSug, ir, morePopular, language, indexSearcher, min, fields, goalFreq, sugQueue, hits, stop);
            String[] stringArray = this.suggestedWordsArray(word, startTime, sugQueue);
            return stringArray;
        }
        finally {
            this.releaseSearcher(indexSearcher);
        }
    }

    private String[] suggestedWordsArray(String word, long startTime, SuggestWordQueue sugQueue) {
        String[] list = null;
        int queueSize = sugQueue.size();
        if (queueSize > 0) {
            list = new String[queueSize];
            for (int i = sugQueue.size() - 1; i >= 0; --i) {
                list[i] = ((SuggestWord)sugQueue.pop()).string;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Found suggestions for word '{}' (took {} ms): {}", new Object[]{word, System.currentTimeMillis() - startTime, list});
            }
        } else {
            list = ArrayUtils.EMPTY_STRING_ARRAY;
            if (logger.isDebugEnabled()) {
                logger.debug("No suggestions found for word {} (took {} ms)", (Object)word, (Object)(System.currentTimeMillis() - startTime));
            }
        }
        return list;
    }

    private void getSuggestionWords(String word, int numSug, IndexReader ir, boolean morePopular, String language, IndexSearcher indexSearcher, float min, List<String> fields, int goalFreq, SuggestWordQueue sugQueue, ScoreDoc[] hits, int stop) throws IOException {
        SuggestWord sugWord = new SuggestWord();
        HashSet<String> foundWords = new HashSet<String>();
        for (int i = 0; i < stop; ++i) {
            sugWord.string = indexSearcher.doc(hits[i].doc).get(language != null ? "word-" + language : F_WORD);
            if (sugWord.string == null || word.equals(sugWord.string) || foundWords.contains(sugWord.string)) continue;
            foundWords.add(sugWord.string);
            if (this.shouldSkipWord(word, ir, morePopular, min, fields, goalFreq, sugWord)) continue;
            sugQueue.insertWithOverflow((Object)sugWord);
            if (sugQueue.size() == numSug) {
                min = ((SuggestWord)sugQueue.top()).score;
            }
            sugWord = new SuggestWord();
        }
    }

    private boolean shouldSkipWord(String word, IndexReader ir, boolean morePopular, float min, List<String> fields, int goalFreq, SuggestWord sugWord) throws IOException {
        sugWord.score = this.getStringDistance().getDistance(word, sugWord.string);
        if (sugWord.score < min) {
            return true;
        }
        if (ir != null) {
            sugWord.freq = 0;
            for (String aField : fields) {
                sugWord.freq += ir.docFreq(new Term(aField, sugWord.string));
            }
            return morePopular && goalFreq > sugWord.freq || sugWord.freq < 1;
        }
        return false;
    }

    @NotNull
    private BooleanQuery getClauses(String word, String[] sites, String language, int lengthWord) {
        BooleanQuery query = new BooleanQuery();
        if (language != null) {
            JahiaExtendedSpellChecker.add(query, F_LANGUAGE, language, BooleanClause.Occur.MUST);
        }
        BooleanQuery subQuery = new BooleanQuery();
        query.add(new BooleanClause((Query)subQuery, BooleanClause.Occur.MUST));
        for (String site : sites) {
            JahiaExtendedSpellChecker.add(subQuery, F_SITE, site, BooleanClause.Occur.SHOULD);
        }
        this.addNGRAMQueries(word, lengthWord, query);
        return query;
    }

    @NotNull
    private List<String> getFields(String[] sites, String language) {
        ArrayList<String> fields = new ArrayList<String>();
        for (String site : sites) {
            fields.add(LuceneUtils.getFullTextFieldName(site, language));
            if (language == null) continue;
            fields.add(LuceneUtils.getFullTextFieldName(site, null));
        }
        return fields;
    }

    private void addNGRAMQueries(String word, int lengthWord, BooleanQuery query) {
        for (int ng = JahiaExtendedSpellChecker.getMin(lengthWord); ng <= JahiaExtendedSpellChecker.getMax(lengthWord); ++ng) {
            String key = "gram" + ng;
            String[] grams = JahiaExtendedSpellChecker.formGrams(word, ng);
            if (grams.length == 0) continue;
            if (this.bStart > 0.0f) {
                JahiaExtendedSpellChecker.add(query, "start" + ng, grams[0], this.bStart);
            }
            if (this.bEnd > 0.0f) {
                JahiaExtendedSpellChecker.add(query, "end" + ng, grams[grams.length - 1], this.bEnd);
            }
            for (int i = 0; i < grams.length; ++i) {
                JahiaExtendedSpellChecker.add(query, key, grams[i]);
            }
        }
    }

    private static void add(BooleanQuery q, String name, String value, float boost) {
        TermQuery tq = new TermQuery(new Term(name, value));
        tq.setBoost(boost);
        q.add(new BooleanClause((Query)tq, BooleanClause.Occur.SHOULD));
    }

    private static void add(BooleanQuery q, String name, String value, BooleanClause.Occur occur) {
        q.add(new BooleanClause((Query)new TermQuery(new Term(name, value)), occur));
    }

    private static void add(BooleanQuery q, String name, String value) {
        q.add(new BooleanClause((Query)new TermQuery(new Term(name, value)), BooleanClause.Occur.SHOULD));
    }

    private static String[] formGrams(String text, int ng) {
        int len = text.length();
        String[] res = new String[len - ng + 1];
        for (int i = 0; i < len - ng + 1; ++i) {
            res[i] = text.substring(i, i + ng);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIndex() throws IOException {
        Object object = this.modifyCurrentIndexLock;
        synchronized (object) {
            this.ensureOpen();
            Directory dir = this.spellIndex;
            this.createIndexWriter(dir);
            this.swapSearcher(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exist(String word, String langCode, String site) throws IOException {
        IndexSearcher indexSearcher = this.obtainSearcher();
        try {
            BooleanQuery query = new BooleanQuery();
            JahiaExtendedSpellChecker.add(query, langCode != null ? "word-" + langCode : F_WORD, word, BooleanClause.Occur.MUST);
            JahiaExtendedSpellChecker.add(query, F_SITE, site, BooleanClause.Occur.MUST);
            boolean bl = indexSearcher.search((Query)query, (int)1).scoreDocs.length > 0;
            return bl;
        }
        finally {
            this.releaseSearcher(indexSearcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexDictionary(Dictionary dict, int mergeFactor, int ramMB, String site, String langCode) throws IOException {
        Object object = this.modifyCurrentIndexLock;
        synchronized (object) {
            this.ensureOpen();
            Directory dir = this.spellIndex;
            try (WhitespaceAnalyzer whitespaceAnalyzer = new WhitespaceAnalyzer(Version.LUCENE_36);){
                BytesRef spare;
                IndexWriterConfig writerConfig = new IndexWriterConfig(Version.LUCENE_36, (Analyzer)new LimitTokenCountAnalyzer((Analyzer)whitespaceAnalyzer, Integer.MAX_VALUE)).setRAMBufferSizeMB((double)ramMB);
                IndexWriter writer = new IndexWriter(dir, writerConfig);
                BytesRefIterator iter = dict.getWordsIterator();
                while ((spare = iter.next()) != null) {
                    String word = spare.utf8ToString();
                    int len = word.length();
                    if (len < 3 || this.exist(word, langCode, site)) continue;
                    Document doc = JahiaExtendedSpellChecker.createDocument(word, JahiaExtendedSpellChecker.getMin(len), JahiaExtendedSpellChecker.getMax(len), site, langCode);
                    writer.addDocument(doc);
                }
                writer.close();
                this.swapSearcher(dir);
            }
        }
    }

    private static int getMin(int l) {
        if (l > 5) {
            return 3;
        }
        if (l == 5) {
            return 2;
        }
        return 1;
    }

    private static int getMax(int l) {
        if (l > 5) {
            return 4;
        }
        if (l == 5) {
            return 3;
        }
        return 2;
    }

    private static Document createDocument(String text, int ng1, int ng2, String site, String langCode) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(langCode != null ? "word-" + langCode : F_WORD_INTERNED, langCode != null, text, Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
        doc.add((Fieldable)new Field(F_LANGUAGE, false, langCode, Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
        doc.add((Fieldable)new Field(F_SITE, false, site, Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
        JahiaExtendedSpellChecker.addGram(text, doc, ng1, ng2);
        return doc;
    }

    private static void addGram(String text, Document doc, int ng1, int ng2) {
        int len = text.length();
        for (int ng = ng1; ng <= ng2; ++ng) {
            String key = "gram" + ng;
            String end = null;
            for (int i = 0; i < len - ng + 1; ++i) {
                String gram = text.substring(i, i + ng);
                doc.add((Fieldable)new Field(key, gram, Field.Store.NO, Field.Index.NOT_ANALYZED));
                if (i == 0) {
                    doc.add((Fieldable)new Field("start" + ng, gram, Field.Store.NO, Field.Index.NOT_ANALYZED));
                }
                end = gram;
            }
            if (end == null) continue;
            doc.add((Fieldable)new Field("end" + ng, end, Field.Store.NO, Field.Index.NOT_ANALYZED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher obtainSearcher() {
        Object object = this.searcherLock;
        synchronized (object) {
            this.ensureOpen();
            this.searcher.getIndexReader().incRef();
            return this.searcher;
        }
    }

    private void releaseSearcher(IndexSearcher aSearcher) throws IOException {
        aSearcher.getIndexReader().decRef();
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("Spellchecker has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.searcherLock;
        synchronized (object) {
            this.ensureOpen();
            this.closed = true;
            if (this.searcher != null) {
                this.searcher.close();
            }
            this.searcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapSearcher(Directory dir) throws IOException {
        IndexSearcher indexSearcher = this.createSearcher(dir);
        Object object = this.searcherLock;
        synchronized (object) {
            if (this.closed) {
                indexSearcher.close();
                throw new AlreadyClosedException("Spellchecker has been closed");
            }
            if (this.searcher != null) {
                this.searcher.close();
            }
            this.searcher = indexSearcher;
            this.spellIndex = dir;
        }
    }

    IndexSearcher createSearcher(Directory dir) throws IOException {
        return new IndexSearcher(IndexReader.open((Directory)dir));
    }

    boolean isClosed() {
        return this.closed;
    }
}

