/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.security.Privilege;

public class PrivilegeImpl
implements Privilege,
Serializable {
    private String prefixedName;
    private String expandedName;
    private boolean isAbstract;
    private Set<Privilege> declaredAggregates;
    private Set<Privilege> aggregates;
    private transient int hash;
    private String nodePath;
    private Privilege[] aggregatePrivileges = null;
    private Privilege[] declaredPrivileges = null;

    PrivilegeImpl(String prefixedName, String expandedName, boolean anAbstract, Set<Privilege> declaredAggregates, String nodePath) {
        this.prefixedName = prefixedName;
        this.expandedName = expandedName;
        this.isAbstract = anAbstract;
        this.declaredAggregates = declaredAggregates;
        this.aggregates = new HashSet<Privilege>(declaredAggregates);
        for (Privilege priv : declaredAggregates) {
            for (Privilege privilege : priv.getAggregatePrivileges()) {
                this.aggregates.add(privilege);
            }
        }
        this.nodePath = nodePath;
    }

    void addPrivileges(Set<Privilege> p) {
        this.declaredAggregates.removeAll(p);
        if (this.declaredAggregates.addAll(p)) {
            this.aggregates.addAll(this.declaredAggregates);
            for (Privilege priv : p) {
                for (Privilege privilege : priv.getAggregatePrivileges()) {
                    this.aggregates.add(privilege);
                }
            }
        }
        this.declaredPrivileges = null;
        this.aggregatePrivileges = null;
    }

    void removePrivileges(Set<Privilege> p) {
        this.declaredAggregates.removeAll(p);
        this.aggregates.removeAll(p);
    }

    public String getName() {
        return this.expandedName;
    }

    public String getPrefixedName() {
        return this.prefixedName;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isAggregate() {
        return !this.declaredAggregates.isEmpty();
    }

    public Privilege[] getDeclaredAggregatePrivileges() {
        if (this.declaredPrivileges == null) {
            this.declaredPrivileges = this.declaredAggregates.toArray(new Privilege[this.declaredAggregates.size()]);
        }
        return this.declaredPrivileges;
    }

    public Privilege[] getAggregatePrivileges() {
        if (this.aggregatePrivileges == null) {
            this.aggregatePrivileges = this.aggregates.toArray(new Privilege[this.aggregates.size()]);
        }
        return this.aggregatePrivileges;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegeImpl that = (PrivilegeImpl)o;
        return !(this.expandedName != null ? !this.expandedName.equals(that.expandedName) : that.expandedName != null);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.expandedName != null) {
            this.hash = this.expandedName.hashCode();
        }
        return h;
    }
}

