/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NamespaceException;
import javax.jcr.query.qom.PropertyValue;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.lucene.CountRow;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.jahia.settings.SettingsBean;

public class CountHandler {
    private static final String COUNT_FUNC_LPAR = "count(";
    private static final Name REP_COUNT_LPAR = NameFactoryImpl.getInstance().create("internal", "count(");
    private static final Pattern APPROX_COUNT_LIMIT_PATTERN = Pattern.compile(".*approxCountLimit=(\\d*).*");

    public static CountType hasCountFunction(Map<String, PropertyValue> columns, SessionImpl session) {
        CountType countType = null;
        try {
            String repCount = session.getJCRName(REP_COUNT_LPAR);
            for (String column : columns.keySet()) {
                Matcher matcher;
                if (!column.trim().startsWith(repCount)) continue;
                countType = new CountType();
                String countSettings = StringUtils.substringBetween((String)column, (String)repCount, (String)")");
                if (countSettings.contains("skipChecks=1")) {
                    countType.setSkipChecks(true);
                }
                if (countSettings.contains("approximate=1")) {
                    countType.setApproxCount(true);
                }
                if ((matcher = APPROX_COUNT_LIMIT_PATTERN.matcher(countSettings)).matches()) {
                    countType.setApproxCount(true);
                    countType.setApproxCountLimit(Integer.parseInt(matcher.group(1)));
                }
                break;
            }
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return countType;
    }

    public static CountRow createCountRow(long count, boolean wasApproxLimitReached) {
        return new CountRow(count, wasApproxLimitReached);
    }

    public static class CountType {
        private boolean approxCount;
        private boolean skipChecks;
        private int approxCountLimit = SettingsBean.getInstance().getQueryApproxCountLimit();

        public boolean isApproxCount() {
            return this.approxCount;
        }

        public void setApproxCount(boolean approxCount) {
            this.approxCount = approxCount;
        }

        public boolean isSkipChecks() {
            return this.skipChecks;
        }

        public void setSkipChecks(boolean skipChecks) {
            this.skipChecks = skipChecks;
        }

        public int getApproxCountLimit() {
            return this.approxCountLimit;
        }

        public void setApproxCountLimit(int approxCountLimit) {
            this.approxCountLimit = approxCountLimit;
        }
    }
}

