/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.commons.query.sql2.QOMFormatter;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryObjectModelImpl;
import org.apache.jackrabbit.core.query.lucene.JahiaLuceneQueryFactoryImpl;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryFactory;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.join.JahiaQueryEngine;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;
import org.apache.jackrabbit.stats.RepositoryStatisticsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaQueryObjectModelImpl
extends QueryObjectModelImpl {
    private static final Logger log = LoggerFactory.getLogger(QueryObjectModelImpl.class);

    public void init(SessionContext sessionContext, QueryHandler handler, QueryObjectModelTree qomTree, String language, Node node) throws InvalidQueryException, RepositoryException {
        super.init(sessionContext, handler, qomTree, language, node);
        this.lqf = new JahiaLuceneQueryFactoryImpl(sessionContext.getSessionImpl(), (SearchIndex)handler, this.variables);
        QueryObjectModelFactory qomQueryFactory = sessionContext.getSessionImpl().getWorkspace().getQueryManager().getQOMFactory();
        boolean hasFacet = false;
        if (this.getColumns() != null) {
            ArrayList<Column> columns = new ArrayList<Column>();
            for (Column col : this.getColumns()) {
                if (col.getColumnName() != null && col.getColumnName().startsWith("rep:facet")) {
                    try {
                        hasFacet = true;
                        columns.add(qomQueryFactory.column(col.getSelectorName(), col.getPropertyName(), String.format("\"%s\"", col.getColumnName())));
                    }
                    catch (Exception e) {
                        log.warn("Unable to generate statement for column {} with column name {}", (Object)col, (Object)col.getColumnName());
                        columns.add(col);
                    }
                    continue;
                }
                columns.add(col);
            }
            if (hasFacet) {
                this.statement = QOMFormatter.format((QueryObjectModel)qomQueryFactory.createQuery(this.getSource(), this.getConstraint(), this.getOrderings(), columns.toArray(new Column[0])));
            }
        }
    }

    public QueryResult execute() throws RepositoryException {
        long time = System.nanoTime();
        QueryResult result = (QueryResult)this.sessionContext.getSessionState().perform((SessionOperation)new SessionOperation<QueryResult>(){

            public QueryResult perform(SessionContext context) throws RepositoryException {
                JahiaQueryEngine engine = new JahiaQueryEngine((Session)JahiaQueryObjectModelImpl.this.sessionContext.getSessionImpl(), JahiaQueryObjectModelImpl.this.lqf, JahiaQueryObjectModelImpl.this.variables);
                return engine.execute(JahiaQueryObjectModelImpl.this.getColumns(), JahiaQueryObjectModelImpl.this.getSource(), JahiaQueryObjectModelImpl.this.getConstraint(), JahiaQueryObjectModelImpl.this.getOrderings(), JahiaQueryObjectModelImpl.this.offset, JahiaQueryObjectModelImpl.this.limit);
            }

            public String toString() {
                return "query.execute(" + JahiaQueryObjectModelImpl.this.statement + ")";
            }
        });
        time = System.nanoTime() - time;
        long timeMs = time / 1000000L;
        log.debug("executed in {} ms. ({})", (Object)timeMs, (Object)this.statement);
        RepositoryStatisticsImpl statistics = this.sessionContext.getRepositoryContext().getRepositoryStatistics();
        statistics.getCounter(RepositoryStatistics.Type.QUERY_COUNT).incrementAndGet();
        statistics.getCounter(RepositoryStatistics.Type.QUERY_DURATION).addAndGet(timeMs);
        this.sessionContext.getRepositoryContext().getStatManager().getQueryStat().logQuery(this.language, this.statement, timeMs);
        return result;
    }

    public LuceneQueryFactory getLuceneQueryFactory() {
        return this.lqf;
    }
}

