/**
 * ==========================================================================================
 * =                   JAHIA'S DUAL LICENSING - IMPORTANT INFORMATION                       =
 * ==========================================================================================
 *
 *     Copyright (C) 2002-2015 Jahia Solutions Group SA. All rights reserved.
 *
 *     THIS FILE IS AVAILABLE UNDER TWO DIFFERENT LICENSES:
 *     1/GPL OR 2/JSEL
 *
 *     1/ GPL
 *     ======================================================================================
 *
 *     IF YOU DECIDE TO CHOSE THE GPL LICENSE, YOU MUST COMPLY WITH THE FOLLOWING TERMS:
 *
 *     "This program is free software; you can redistribute it and/or
 *     modify it under the terms of the GNU General Public License
 *     as published by the Free Software Foundation; either version 2
 *     of the License, or (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *     As a special exception to the terms and conditions of version 2.0 of
 *     the GPL (or any later version), you may redistribute this Program in connection
 *     with Free/Libre and Open Source Software ("FLOSS") applications as described
 *     in Jahia's FLOSS exception. You should have received a copy of the text
 *     describing the FLOSS exception, also available here:
 *     http://www.jahia.com/license"
 *
 *     2/ JSEL - Commercial and Supported Versions of the program
 *     ======================================================================================
 *
 *     IF YOU DECIDE TO CHOOSE THE JSEL LICENSE, YOU MUST COMPLY WITH THE FOLLOWING TERMS:
 *
 *     Alternatively, commercial and supported versions of the program - also known as
 *     Enterprise Distributions - must be used in accordance with the terms and conditions
 *     contained in a separate written agreement between you and Jahia Solutions Group SA.
 *
 *     If you are unsure which license is appropriate for your use,
 *     please contact the sales department at sales@jahia.com.
 *
 *
 * ==========================================================================================
 * =                                   ABOUT JAHIA                                          =
 * ==========================================================================================
 *
 *     Rooted in Open Source CMS, Jahia’s Digital Industrialization paradigm is about
 *     streamlining Enterprise digital projects across channels to truly control
 *     time-to-market and TCO, project after project.
 *     Putting an end to “the Tunnel effect”, the Jahia Studio enables IT and
 *     marketing teams to collaboratively and iteratively build cutting-edge
 *     online business solutions.
 *     These, in turn, are securely and easily deployed as modules and apps,
 *     reusable across any digital projects, thanks to the Jahia Private App Store Software.
 *     Each solution provided by Jahia stems from this overarching vision:
 *     Digital Factory, Workspace Factory, Portal Factory and eCommerce Factory.
 *     Founded in 2002 and headquartered in Geneva, Switzerland,
 *     Jahia Solutions Group has its North American headquarters in Washington DC,
 *     with offices in Chicago, Toronto and throughout Europe.
 *     Jahia counts hundreds of global brands and governmental organizations
 *     among its loyal customers, in more than 20 countries across the globe.
 *
 *     For more information, please visit http://www.jahia.com
 */
package org.jahia.ajax.gwt.client.widget.content;

import com.extjs.gxt.ui.client.core.DomQuery;
import com.extjs.gxt.ui.client.event.ListViewEvent;
import com.extjs.gxt.ui.client.util.Format;
import com.extjs.gxt.ui.client.widget.ListView;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.Element;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.util.URL;
import org.jahia.ajax.gwt.client.util.icons.ContentModelIconProvider;

/**
 *
 * User: toto
 * Date: Dec 21, 2009
 * Time: 11:12:37 AM
 *
 */
public class ThumbsListView extends ListView<GWTJahiaNode> {

    private boolean detailed = false;

    public ThumbsListView() {
        setItemSelector("div.thumb-wrap");
        setOverStyle("x-view-over");
    }


    public ThumbsListView(boolean detailed) {
        this();
        this.detailed = detailed;
        if (detailed) {
            setTemplate(getDetailedTemplate());
        } else {
            setTemplate(getSimpleTemplate());
        }
    }

    @Override
    protected GWTJahiaNode prepareData(GWTJahiaNode model) {
        if (model.getNodeTypes().contains("jmix:markedForDeletion")) {
            model.set("markedForDeletion", "true" );
        } else {
            model.set("markedForDeletion", "false" );
        }
        model.set("shortName",  SafeHtmlUtils.htmlEscape(Format.ellipse(model.getName(), 14)));
        model.set("nameLabel", Messages.get("label.name", "Name"));
        model.set("titleLabel", Messages.get("label.title", "Title"));
        model.set("authorLabel", Messages.get("versioning_author", "Author"));
        model.set("tagsLabel", Messages.get("org.jahia.jcr.edit.tags.tab", "tags"));
        model.set("createdBy", model.get("jcr:createdBy"));
        String width = model.get("j:width");
        if (width != null) {
            if (Integer.parseInt(width) < 80) {
                model.set("nodeImg", "<img src=\"" + URL.appendTimestamp(model.getUrl()) + "\" title=\"" + SafeHtmlUtils.htmlEscape(model.getName()) + "\">");
            } else {
                model.set("nodeImg", "<img src=\"" + URL.appendTimestamp(model.getPreview()) + "\" title=\"" + SafeHtmlUtils.htmlEscape(model.getName()) + "\">");
            }
            if (detailed) {
                model.set("widthHTML", "<div><b>" + Messages.get("width.label", "Width") + " </b>" + model.get("j:width") + " px</div>");
                model.set("heightHTML", "<div><b>" + Messages.get("height.label", "Height") + " </b>" + model.get("j:height") + " px</div>");
            } else {
                model.set("widthAndHeightHTML", model.get("j:width") + " x " + model.get("j:height"));
            }
        } else if (model.getPreview() != null) {
            model.set("nodeImg", "<img src=\"" + URL.appendTimestamp(model.getPreview()) + "\" title=\"" + SafeHtmlUtils.htmlEscape(model.getName()) + "\">");
        } else {
            model.set("nodeImg", ContentModelIconProvider.getInstance().getIcon(model, true).getHTML());
        }

        if (model.getTags() != null && model.getTags().length() > 0) {
            model.set("tagsHTML", "<div><b>" + model.get("tagsLabel") + ": </b>" + SafeHtmlUtils.htmlEscape(model.getTags()) + "</div>");
        }
        return model;
    }

    protected void onMouseDown(ListViewEvent<GWTJahiaNode> e) {
        super.onMouseDown(e);
        if (e.getIndex() == -1) {
            getSelectionModel().select((GWTJahiaNode) null, false);
        }
    }

    public void setContextMenu(Menu menu) {
        super.setContextMenu(menu);
    }

    public void setSize(int thumbnailSize) {
        NodeList<Element> imageThumbNails = DomQuery.select("#images-view .thumb");
        for (int i=0; i < imageThumbNails.getLength(); i++) {
            Element currentThumbnail = imageThumbNails.getItem(i);
            currentThumbnail.getStyle().setWidth(thumbnailSize, Style.Unit.PX);
            currentThumbnail.getStyle().setHeight(thumbnailSize, Style.Unit.PX);
        }
    }

    public native String getSimpleTemplate() /*-{
        return ['<tpl for=".">',
            '<div title="{name}" class="thumb-wrap" id="{name}">',
            '<div class="thumb">{nodeImg}</div>',
            '<tpl if="markedForDeletion == \'true\'">',
            '<span class="markedForDeletion">',
            '</tpl>',
            '<span class="x-editable">{shortName}</span>',
            '<tpl if="markedForDeletion == \'true\'">',
            '</span>',
            '</tpl>',
            '<span class="x-editable">{widthAndHeightHTML}</span>',
            '</div>',
            '</tpl>',
            '<div class="x-clear"></div>'
        ].join("");

    }-*/;


    public native String getDetailedTemplate() /*-{
        return ['<tpl for=".">',
            '<div style="padding: 5px ;border-bottom: 1px solid #D9E2F4;float: left;width: 100%;" class="thumb-wrap" id="{name}">',
            '<div><div style="width: 140px; float: left; text-align: center;" class="thumb">{nodeImg}</div>',
            '<div style="margin-left: 160px; " class="thumbDetails">',
            '<div><tpl if="markedForDeletion == \'true\'">',
            '<span class="markedForDeletion" style="text-align:left;">',
            '</tpl>',
            '<b>{nameLabel}: </b>{name}',
            '<tpl if="markedForDeletion == \'true\'">',
            '</span>',
            '</tpl></div>',
            '<div><b>{titleLabel}: </b>{displayName}</div>',
            '<div><b>{authorLabel}: </b>{createdBy}</div>',
            '{widthHTML}',
            '{heightHTML}',
            '{tagsHTML}',
            '</div>',
            '</div>',
            '<div style="padding-left: 10px; padding-top: 10px; clear: left">{description}</div></div>',
            '</tpl>',
            '<div class="x-clear"></div>'
        ].join("");
    }-*/;

}
