/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.migration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.jahia.commons.Version;
import org.jahia.utils.migration.model.Migration;
import org.jahia.utils.migration.model.MigrationOperation;
import org.jahia.utils.migration.model.MigrationResource;
import org.jahia.utils.migration.model.Migrations;

public class Migrators {
    private static final Migrators instance = new Migrators();
    private Migrations migrationsConfig = null;

    public Migrators() {
        InputStream migrationConfigInputStream = this.getClass().getClassLoader().getResourceAsStream("org/jahia/utils/migration/migrations.xml");
        try {
            this.migrationsConfig = this.unmarshal(Migrations.class, migrationConfigInputStream);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public static Migrators getInstance() {
        return instance;
    }

    private <T> T unmarshal(Class<T> docClass, InputStream inputStream) throws JAXBException, XMLStreamException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{docClass});
        Unmarshaller u = jc.createUnmarshaller();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(inputStream);
        Object doc = u.unmarshal(xmlStreamReader);
        return (T)doc;
    }

    private void marshal(Class docClass, Object jaxbElement, OutputStream outputStream) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{docClass});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.marshal(jaxbElement, outputStream);
    }

    public boolean willMigrate(InputStream inputStream, String filePath, Version fromVersion, Version toVersion) {
        for (Migration migration : this.migrationsConfig.getMigrations()) {
            if (!migration.getFromVersion().equals((Object)fromVersion) || !migration.getToVersion().equals((Object)toVersion)) continue;
            for (MigrationResource migrationResource : migration.getMigrationResources()) {
                Matcher resourcePatternMatcher = migrationResource.getCompiledPattern().matcher(filePath);
                if (!resourcePatternMatcher.matches()) continue;
                for (MigrationOperation migrationOperation : migrationResource.getOperations()) {
                    if (!migrationOperation.willMigrate(inputStream, filePath)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<String> migrate(InputStream inputStream, OutputStream outputStream, String filePath, Version fromVersion, Version toVersion, boolean performModification) {
        ArrayList<String> messages = new ArrayList<String>();
        for (Migration migration : this.migrationsConfig.getMigrations()) {
            if (!migration.getFromVersion().equals((Object)fromVersion) || !migration.getToVersion().equals((Object)toVersion)) continue;
            for (MigrationResource migrationResource : migration.getMigrationResources()) {
                Matcher resourcePatternMatcher = migrationResource.getCompiledPattern().matcher(filePath);
                if (!resourcePatternMatcher.matches()) continue;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    IOUtils.copyLarge(inputStream, byteArrayOutputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                byte[] inputByteArray = byteArrayOutputStream.toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(inputByteArray);
                byteArrayOutputStream.reset();
                for (MigrationOperation migrationOperation : migrationResource.getOperations()) {
                    messages.addAll(migrationOperation.execute(byteArrayInputStream, byteArrayOutputStream, filePath, performModification));
                    byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream.reset();
                }
                try {
                    if (outputStream == null) continue;
                    IOUtils.copyLarge(byteArrayInputStream, outputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return messages;
    }
}

