/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.PropertyUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jahia.commons.encryption.EncryptionUtils;
import org.jahia.configuration.configurators.AbstractConfigurator;
import org.jahia.configuration.configurators.ApplicationXmlConfigurator;
import org.jahia.configuration.configurators.ConfigFile;
import org.jahia.configuration.configurators.DatabaseConnection;
import org.jahia.configuration.configurators.DatabaseScripts;
import org.jahia.configuration.configurators.JBossConfigurator;
import org.jahia.configuration.configurators.JackrabbitConfigurator;
import org.jahia.configuration.configurators.JahiaConfigBean;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jahia.configuration.configurators.JahiaNodePropertiesConfigurator;
import org.jahia.configuration.configurators.JahiaPropertiesConfigurator;
import org.jahia.configuration.configurators.LDAPConfigurator;
import org.jahia.configuration.configurators.MailServerConfigurator;
import org.jahia.configuration.configurators.RootUserConfigurator;
import org.jahia.configuration.configurators.TomcatContextXmlConfigurator;
import org.jahia.configuration.configurators.VFSConfigFile;
import org.jahia.configuration.deployers.ServerDeploymentFactory;
import org.jahia.configuration.deployers.ServerDeploymentInterface;
import org.jahia.configuration.logging.AbstractLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class JahiaGlobalConfigurator {
    private static final ConvertUtilsBean CONVERTER_UTILS_BEAN = new ConvertUtilsBean();
    JahiaConfigInterface jahiaConfig;
    DatabaseConnection db;
    File webappDir;
    Properties dbProps;
    File databaseScript;
    List<AbstractConfigurator> configurators = new ArrayList<AbstractConfigurator>();
    String externalizedConfigTempPath = null;
    File jahiaConfigDir;
    AbstractLogger logger;
    private ServerDeploymentInterface deployer;
    private File dataDir;

    public static Map<String, String> fromJSON(String json) {
        HashMap<String, String> values = new HashMap<String, String>();
        try {
            JSONObject obj = new JSONObject(json.contains("{") ? StringUtils.replace((String)json, (String)"\\", (String)"\\\\") : "{" + StringUtils.replace((String)json, (String)"\\", (String)"\\\\") + "}");
            Iterator iterator = obj.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                values.put(key, obj.getString(key));
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return values;
    }

    public static List<String> fromString(String value) {
        LinkedList<String> valueList = new LinkedList<String>();
        if (value != null && value.length() > 0) {
            for (String singleValue : StringUtils.split((String)value, (String)" ,;:")) {
                valueList.add(singleValue.trim());
            }
        }
        return valueList;
    }

    public static File resolveDataDir(String dataDirPath, String targetWebappDirPath) {
        return JahiaGlobalConfigurator.resolveDataDir(dataDirPath, targetWebappDirPath, true);
    }

    public static File resolveDataDir(String dataDirPath, String targetWebappDirPath, boolean doCreate) {
        File dataDir = null;
        if (dataDirPath.indexOf(36) != -1) {
            HashMap<String, String> sysProps = new HashMap<String, String>();
            String webappPath = targetWebappDirPath;
            sysProps.put("jahiaWebAppRoot", webappPath);
            if (dataDirPath.contains("$context")) {
                sysProps.put("context", webappPath);
            }
            for (Map.Entry<Object, Object> el : System.getProperties().entrySet()) {
                sysProps.put(String.valueOf(el.getKey()), String.valueOf(el.getValue()));
            }
            dataDirPath = StringUtils.interpolate((String)dataDirPath, sysProps);
        }
        try {
            dataDir = new File(dataDirPath).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (doCreate && !dataDir.exists() && !dataDir.mkdirs()) {
            throw new RuntimeException("Unable to create target directory: " + dataDir);
        }
        return dataDir;
    }

    public JahiaGlobalConfigurator(AbstractLogger logger, JahiaConfigInterface jahiaConfig) {
        this.jahiaConfig = jahiaConfig;
        this.logger = logger;
    }

    public AbstractLogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        if (this.jahiaConfig.isExternalizedConfigActivated() && !StringUtils.isBlank((String)this.jahiaConfig.getExternalizedConfigTargetPath())) {
            File tempDirectory = FileUtils.getTempDirectory();
            this.jahiaConfigDir = new File(tempDirectory, "jahia-config");
            File jahiaConfigConfigDir = new File(this.jahiaConfigDir, "jahia");
            jahiaConfigConfigDir.mkdirs();
            this.externalizedConfigTempPath = jahiaConfigConfigDir.getPath();
        }
        this.db = new DatabaseConnection();
        this.getLogger().info("Configuring for server " + this.jahiaConfig.getTargetServerType() + (StringUtils.isNotEmpty((String)this.jahiaConfig.getTargetServerVersion()) ? " version " + this.jahiaConfig.getTargetServerVersion() : "") + " with database type " + this.jahiaConfig.getDatabaseType());
        try {
            this.setProperties();
        }
        finally {
            VFSConfigFile.closeAllOpened();
        }
    }

    private void deployOnCluster() {
    }

    private void cleanDatabase() {
        int begindatabasename = this.jahiaConfig.getDatabaseUrl().indexOf("/", 13);
        int enddatabaseName = this.jahiaConfig.getDatabaseUrl().indexOf("?", begindatabasename);
        String databaseName = "`" + this.jahiaConfig.getDatabaseUrl().substring(begindatabasename + 1, enddatabaseName) + "`";
        try {
            this.db.query("drop  database if exists " + databaseName);
            this.db.query("create database " + databaseName);
            this.db.query("alter database " + databaseName + " charset utf8");
        }
        catch (Throwable t) {
            this.getLogger().info("error in " + databaseName + " because of" + t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfigurationFiles(String sourceWebAppPath, String webappPath, Properties dbProps, JahiaConfigInterface jahiaConfigInterface) throws Exception {
        boolean jeeLocationSpecified;
        String mailServerTemplate;
        this.getLogger().info("Configuring file using source " + sourceWebAppPath + " to target " + webappPath);
        FileSystemManager fsManager = VFS.getManager();
        new JackrabbitConfigurator(dbProps, jahiaConfigInterface, this.getLogger()).updateConfiguration(new VFSConfigFile(fsManager, sourceWebAppPath + "/WEB-INF/etc/repository/jackrabbit/repository.xml"), webappPath + "/WEB-INF/etc/repository/jackrabbit/repository.xml");
        new TomcatContextXmlConfigurator(dbProps, jahiaConfigInterface).updateConfiguration(new VFSConfigFile(fsManager, sourceWebAppPath + "/META-INF/context.xml"), webappPath + "/META-INF/context.xml");
        String rootUserTemplate = sourceWebAppPath + "/WEB-INF/etc/repository/template-root-user.xml";
        FileObject rootUserTemplateFile = fsManager.resolveFile(rootUserTemplate);
        if (rootUserTemplateFile.exists()) {
            if (Boolean.valueOf(jahiaConfigInterface.getProcessingServer()).booleanValue()) {
                new RootUserConfigurator((Map)dbProps, jahiaConfigInterface, JahiaGlobalConfigurator.encryptPassword(jahiaConfigInterface.getJahiaRootPassword())).updateConfiguration(new VFSConfigFile(fsManager, rootUserTemplate), webappPath + "/WEB-INF/etc/repository/root-user.xml");
            }
        } else {
            new RootUserConfigurator((Map)dbProps, jahiaConfigInterface, JahiaGlobalConfigurator.encryptPassword(jahiaConfigInterface.getJahiaRootPassword())).updateConfiguration(new VFSConfigFile(fsManager, sourceWebAppPath + "/WEB-INF/etc/repository/root.xml"), webappPath + "/WEB-INF/etc/repository/root.xml");
        }
        if (fsManager.resolveFile(mailServerTemplate = sourceWebAppPath + "/WEB-INF/etc/repository/template-root-mail-server.xml").exists() && Boolean.valueOf(jahiaConfigInterface.getProcessingServer()).booleanValue()) {
            new MailServerConfigurator(dbProps, jahiaConfigInterface).updateConfiguration(new VFSConfigFile(fsManager, mailServerTemplate), webappPath + "/WEB-INF/etc/repository/root-mail-server.xml");
        }
        if ("jboss".equalsIgnoreCase(jahiaConfigInterface.getTargetServerType())) {
            this.updateForJBoss(dbProps, jahiaConfigInterface, fsManager);
        }
        String targetConfigPath = webappPath + "/WEB-INF/etc/config";
        String jahiaPropertiesFileName = "jahia.properties";
        String jahiaNodePropertiesFileName = "jahia.node.properties";
        if (this.externalizedConfigTempPath != null) {
            targetConfigPath = this.externalizedConfigTempPath;
            if (!StringUtils.isBlank((String)jahiaConfigInterface.getExternalizedConfigClassifier())) {
                jahiaPropertiesFileName = "jahia." + jahiaConfigInterface.getExternalizedConfigClassifier() + ".properties";
                jahiaNodePropertiesFileName = "jahia.node." + jahiaConfigInterface.getExternalizedConfigClassifier() + ".properties";
            }
        }
        ConfigFile jahiaPropertiesConfigFile = this.readJahiaProperties(sourceWebAppPath, fsManager);
        new JahiaPropertiesConfigurator(dbProps, jahiaConfigInterface).updateConfiguration(jahiaPropertiesConfigFile, targetConfigPath + "/" + jahiaPropertiesFileName);
        try {
            ConfigFile jahiaNodePropertiesConfigFile = this.readJahiaNodeProperties(sourceWebAppPath, fsManager);
            if (jahiaNodePropertiesConfigFile != null) {
                new JahiaNodePropertiesConfigurator(this.logger, jahiaConfigInterface).updateConfiguration(jahiaNodePropertiesConfigFile, targetConfigPath + "/" + jahiaNodePropertiesFileName);
            }
        }
        catch (FileSystemException jahiaNodePropertiesConfigFile) {
            // empty catch block
        }
        InputStream is = this.getClass().getResourceAsStream("/applicationcontext-custom.xml");
        FileOutputStream os = new FileOutputStream(new File(targetConfigPath, "applicationcontext-custom.xml"));
        try {
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
        }
        String ldapTargetFile = new File(this.getDataDir(), "modules").getAbsolutePath();
        new LDAPConfigurator(dbProps, jahiaConfigInterface).updateConfiguration(new VFSConfigFile(fsManager, sourceWebAppPath), ldapTargetFile);
        String jeeApplicationLocation = jahiaConfigInterface.getJeeApplicationLocation();
        boolean bl = jeeLocationSpecified = !StringUtils.isEmpty((String)jeeApplicationLocation);
        if (jeeLocationSpecified || this.getDeployer().isEarDeployment()) {
            String jeeApplicationModuleList;
            if (!jeeLocationSpecified) {
                jeeApplicationLocation = this.getDeployer().getDeploymentFilePath("digitalfactory", "ear").getAbsolutePath();
            }
            if (StringUtils.isEmpty((String)(jeeApplicationModuleList = jahiaConfigInterface.getJeeApplicationModuleList()))) {
                jeeApplicationModuleList = "ROOT".equals(jahiaConfigInterface.getWebAppDirName()) ? "jahia-war:web:jahia.war:" : "jahia-war:web:jahia.war:" + jahiaConfigInterface.getWebAppDirName();
            }
            new ApplicationXmlConfigurator(jahiaConfigInterface, jeeApplicationModuleList).updateConfiguration(new VFSConfigFile(fsManager, jeeApplicationLocation + "/META-INF/application.xml"), jeeApplicationLocation + "/META-INF/application.xml");
        }
    }

    private ConfigFile readJahiaNodeProperties(String sourceWebAppPath, FileSystemManager fsManager) throws FileSystemException {
        URL jarUrl = null;
        FileObject jahiaEEImplFileObject = this.findVFSFile(sourceWebAppPath + "/WEB-INF/lib", "jahia\\-ee\\-impl.*\\.jar");
        jarUrl = jahiaEEImplFileObject != null ? jahiaEEImplFileObject.getURL() : this.getClass().getClassLoader().getResource("jahia-default-config.jar");
        if (jarUrl != null) {
            return new VFSConfigFile(fsManager.resolveFile("jar:" + jarUrl.toExternalForm()), "org/jahia/defaults/config/properties/jahia.node.properties");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigFile readJahiaProperties(String sourceWebAppPath, FileSystemManager fsManager) throws IOException {
        ConfigFile cfg;
        block12: {
            cfg = null;
            FileObject jahiaImplFileObject = this.findVFSFile(sourceWebAppPath + "/WEB-INF/lib", "jahia\\-impl\\-.*\\.jar");
            URL jahiaDefaultConfigJARURL = this.getClass().getClassLoader().getResource("jahia-default-config.jar");
            if (jahiaImplFileObject != null) {
                jahiaDefaultConfigJARURL = jahiaImplFileObject.getURL();
            }
            VFSConfigFile jahiaPropertiesConfigFile = null;
            VFSConfigFile jahiaAdvancedPropertiesConfigFile = null;
            try {
                cfg = jahiaPropertiesConfigFile = new VFSConfigFile(fsManager.resolveFile("jar:" + jahiaDefaultConfigJARURL.toExternalForm()), "org/jahia/defaults/config/properties/jahia.properties");
                FileObject jahiaEEImplFileObject = this.findVFSFile(sourceWebAppPath + "/WEB-INF/lib", "jahia\\-ee\\-impl.*\\.jar");
                if (jahiaEEImplFileObject != null) {
                    jahiaDefaultConfigJARURL = jahiaEEImplFileObject.getURL();
                }
                try {
                    jahiaAdvancedPropertiesConfigFile = new VFSConfigFile(fsManager.resolveFile("jar:" + jahiaDefaultConfigJARURL.toExternalForm()), "org/jahia/defaults/config/properties/jahia.advanced.properties");
                    if (jahiaAdvancedPropertiesConfigFile == null) break block12;
                    InputStream is1 = jahiaPropertiesConfigFile.getInputStream();
                    InputStream is2 = jahiaAdvancedPropertiesConfigFile.getInputStream();
                    try {
                        final String content = IOUtils.toString((InputStream)is1) + "\n" + IOUtils.toString((InputStream)is2);
                        cfg = new ConfigFile(){

                            @Override
                            public URI getURI() throws IOException, URISyntaxException {
                                return null;
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return IOUtils.toInputStream((String)content);
                            }
                        };
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)is1);
                        IOUtils.closeQuietly((InputStream)is2);
                    }
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
            }
            finally {
                if (jahiaPropertiesConfigFile != null) {
                    jahiaPropertiesConfigFile.close();
                }
                if (jahiaAdvancedPropertiesConfigFile != null) {
                    jahiaAdvancedPropertiesConfigFile.close();
                }
            }
        }
        return cfg;
    }

    private void updateForJBoss(Properties dbProps, JahiaConfigInterface jahiaConfigInterface, FileSystemManager fsManager) throws Exception, FileSystemException, IOException {
        JBossConfigurator configurator = new JBossConfigurator(dbProps, jahiaConfigInterface, this.getDeployer(), this.getLogger());
        File datasourcePath = new File(jahiaConfigInterface.getTargetServerDirectory(), "standalone/configuration/standalone.xml");
        if (datasourcePath.exists()) {
            configurator.updateConfiguration(new VFSConfigFile(fsManager, datasourcePath.getPath()), datasourcePath.getPath());
        } else {
            File cliFile;
            File fragmentFile = new File(jahiaConfigInterface.getTargetServerDirectory(), "standalone/configuration/standalone.xml.fragment");
            if (fragmentFile.exists()) {
                configurator.updateConfiguration(new VFSConfigFile(fsManager, fragmentFile.getPath()), fragmentFile.getPath());
            }
            if ((cliFile = new File(jahiaConfigInterface.getTargetServerDirectory(), "bin/jahia-config.cli")).exists()) {
                configurator.writeCLIConfiguration(cliFile, null);
                configurator.writeCLIConfiguration(new File(jahiaConfigInterface.getTargetServerDirectory(), "bin/jahia-config-domain.cli"), "default");
            }
        }
        configurator.updateDriverModule();
    }

    public FileObject findVFSFile(String parentPath, String fileMatchingPattern) {
        Pattern matchingPattern = Pattern.compile(fileMatchingPattern);
        try {
            FileObject[] children;
            FileSystemManager fsManager = VFS.getManager();
            FileObject parentFileObject = fsManager.resolveFile(parentPath);
            for (FileObject child : children = parentFileObject.getChildren()) {
                Matcher matcher = matchingPattern.matcher(child.getName().getBaseName());
                if (!matcher.matches()) continue;
                return child;
            }
        }
        catch (FileSystemException e) {
            this.logger.debug("Couldn't find file matching pattern " + fileMatchingPattern + " at path " + parentPath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperties() throws Exception {
        this.webappDir = this.getWebappDeploymentDir();
        String sourceWebappPath = this.webappDir.toString();
        if (this.jahiaConfig.getCluster_activated().equals("true")) {
            this.getLogger().info(" Deploying in cluster for server in " + this.webappDir);
            this.deployOnCluster();
        } else {
            this.getLogger().info("Deployed in standalone for server in " + this.webappDir);
        }
        String dbUrl = this.jahiaConfig.getDatabaseUrl();
        boolean isEmbeddedDerby = this.jahiaConfig.getDatabaseType().equals("derby_embedded");
        if (isEmbeddedDerby) {
            if (this.jahiaConfig.getDatabaseUrl().contains("$context")) {
                dbUrl = StringUtils.replace((String)dbUrl, (String)"$context", (String)StringUtils.replace((String)sourceWebappPath, (String)"\\", (String)"/"));
            } else {
                System.setProperty("derby.system.home", StringUtils.replace((String)new File(this.getDataDir(), "dbdata").getAbsolutePath(), (String)"\\", (String)"/"));
            }
        }
        this.dbProps = new Properties();
        this.databaseScript = new File(this.getDataDir(), "db/" + this.jahiaConfig.getDatabaseType() + ".script");
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.databaseScript);
            this.dbProps.load(is);
            this.dbProps.put("storeFilesInDB", this.jahiaConfig.getStoreFilesInDB());
            this.dbProps.put("fileDataStorePath", this.jahiaConfig.getFileDataStorePath() != null ? this.jahiaConfig.getFileDataStorePath() : "");
            this.dbProps.put("jahia.database.url", dbUrl);
            this.dbProps.put("jahia.database.user", this.jahiaConfig.getDatabaseUsername());
            this.dbProps.put("jahia.database.pass", this.jahiaConfig.getDatabasePassword());
        }
        catch (IOException e) {
            try {
                this.getLogger().error("Error in loading database settings because of " + e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
        this.getLogger().info("Updating configuration files...");
        this.updateConfigurationFiles(sourceWebappPath, this.webappDir.getPath(), this.dbProps, this.jahiaConfig);
        this.getLogger().info("Copying license file...");
        String targetConfigPath = this.webappDir.getPath() + "/WEB-INF/etc/config";
        if (this.externalizedConfigTempPath != null) {
            targetConfigPath = this.externalizedConfigTempPath;
        }
        try {
            String existingLicense = this.jahiaConfig.getLicenseFile();
            this.copyLicense(existingLicense != null && existingLicense.length() > 0 ? existingLicense : sourceWebappPath + "/WEB-INF/etc/config/licenses/license-free.xml", targetConfigPath + "/license.xml");
            if (this.jahiaConfig.getOverwritedb().equals("true")) {
                this.getLogger().info("Creating database tables for " + this.jahiaConfig.getDatabaseType() + "...");
                this.getLogger().info("driver: " + this.dbProps.getProperty("jahia.database.driver"));
                this.getLogger().info("url: " + this.jahiaConfig.getDatabaseUrl());
                this.getLogger().info("user: " + this.jahiaConfig.getDatabaseUsername());
                if (!this.databaseScript.exists()) {
                    this.getLogger().info("cannot find script in " + this.databaseScript.getPath());
                    throw new Exception("Cannot find script for database " + this.jahiaConfig.getDatabaseType());
                }
                if (this.jahiaConfig.getDatabaseType().contains("derby") && !dbUrl.contains("create=true")) {
                    dbUrl = dbUrl + ";create=true";
                }
                this.db.databaseOpen(this.dbProps.getProperty("jahia.database.driver"), dbUrl, this.jahiaConfig.getDatabaseUsername(), this.jahiaConfig.getDatabasePassword());
                if (this.jahiaConfig.getDatabaseType().equals("mysql")) {
                    this.getLogger().info("database is mysql trying to drop it and create a new one");
                    this.cleanDatabase();
                    this.db.databaseOpen(this.dbProps.getProperty("jahia.database.driver"), this.jahiaConfig.getDatabaseUrl(), this.jahiaConfig.getDatabaseUsername(), this.jahiaConfig.getDatabasePassword());
                }
                this.createDBTables(this.databaseScript);
                if (isEmbeddedDerby) {
                    this.getLogger().info("Shutting down embedded Derby...");
                    try {
                        DriverManager.getConnection("jdbc:derby:;shutdown=true", this.jahiaConfig.getDatabaseUsername(), this.jahiaConfig.getDatabasePassword());
                    }
                    catch (Exception e) {
                        if (!(e instanceof SQLException) || e.getMessage() == null || !e.getMessage().contains("Derby system shutdown")) {
                            this.logger.warn(e.getMessage(), e);
                        }
                        this.getLogger().info("...done shutting down Derby.");
                    }
                }
            }
            this.deleteRepositoryAndIndexes();
            if ("tomcat".equals(this.jahiaConfig.getTargetServerType())) {
                this.deleteTomcatFiles();
            }
            if (this.jahiaConfig.getSiteImportLocation() != null) {
                File importsFolder = new File(this.getDataDir(), "imports");
                this.getLogger().info("Copying site Export to the " + importsFolder);
                this.copyImports(importsFolder.getAbsolutePath());
            } else {
                this.getLogger().info("No site import found, no import needed.");
            }
            if (this.jahiaConfigDir != null && this.externalizedConfigTempPath != null) {
                this.copyExternalizedConfig();
            }
        }
        catch (Exception e) {
            this.getLogger().error("exception in setting the properties because of " + e, e);
        }
    }

    private void copyExternalizedConfig() throws IOException, ArchiverException {
        if (this.jahiaConfig.isExternalizedConfigExploded()) {
            File target = new File(this.jahiaConfig.getExternalizedConfigTargetPath());
            final File targetCfgDir = new File(target, "jahia");
            final File srcDir = new File(this.jahiaConfigDir, "jahia");
            if (targetCfgDir.isDirectory()) {
                Properties p;
                File jahiaPropsFile = new File(targetCfgDir, "jahia.properties");
                if (jahiaPropsFile.exists() && ((p = PropertyUtils.loadProperties((File)jahiaPropsFile)).containsKey("db_script") && !this.jahiaConfig.getDatabaseType().equals(p.getProperty("db_script")) || !p.containsKey("db_script") && !this.jahiaConfig.getDatabaseType().equals("derby_embedded"))) {
                    this.getLogger().info("Deleting existing " + jahiaPropsFile + " file as the target database type has changed");
                    jahiaPropsFile.delete();
                }
                FileUtils.copyDirectory((File)srcDir, (File)targetCfgDir, (FileFilter)new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (!pathname.isFile()) {
                            return true;
                        }
                        return !new File(targetCfgDir, pathname.getAbsolutePath().substring(srcDir.getAbsolutePath().length())).exists();
                    }
                });
            } else {
                FileUtils.copyDirectoryToDirectory((File)srcDir, (File)target);
            }
        } else {
            boolean verbose = true;
            JarArchiver archiver = new JarArchiver();
            if (verbose) {
                archiver.enableLogging((Logger)new ConsoleLogger(0, "console"));
            }
            String jarFileName = "jahia-config.jar";
            if (!StringUtils.isBlank((String)this.jahiaConfig.getExternalizedConfigFinalName())) {
                jarFileName = this.jahiaConfig.getExternalizedConfigFinalName();
                if (!StringUtils.isBlank((String)this.jahiaConfig.getExternalizedConfigClassifier())) {
                    jarFileName = jarFileName + "-" + this.jahiaConfig.getExternalizedConfigClassifier();
                }
                jarFileName = jarFileName + ".jar";
            }
            File targetFile = new File(this.jahiaConfig.getExternalizedConfigTargetPath(), jarFileName);
            archiver.setDestFile(targetFile);
            String excludes = null;
            archiver.addDirectory(this.jahiaConfigDir, null, excludes != null ? excludes.split(",") : null);
            archiver.createArchive();
        }
        FileUtils.deleteDirectory((File)this.jahiaConfigDir);
    }

    private void copyImports(String importsFolder) {
        for (int i = 0; i < this.jahiaConfig.getSiteImportLocation().size(); ++i) {
            try {
                this.copy(this.jahiaConfig.getSiteImportLocation().get(i), importsFolder);
                continue;
            }
            catch (IOException e) {
                this.getLogger().error("error in copying siteImport file " + e);
            }
        }
    }

    private void cleanDirectory(File toDelete) {
        if (toDelete.exists()) {
            try {
                FileUtils.cleanDirectory((File)toDelete);
            }
            catch (IOException e) {
                this.getLogger().error("Error deleting content of the folder '" + toDelete + "'. Cause: " + e.getMessage(), e);
            }
        }
    }

    private void deleteDirectory(File toDelete) {
        if (toDelete.exists()) {
            try {
                FileUtils.deleteDirectory((File)toDelete);
            }
            catch (IOException e) {
                this.getLogger().error("Error deleting content of the folder '" + toDelete + "'. Cause: " + e.getMessage(), e);
            }
        }
    }

    private void deleteTomcatFiles() {
        File toDelete1 = new File(this.jahiaConfig.getTargetServerDirectory() + "/temp");
        this.cleanDirectory(toDelete1);
        File toDelete2 = new File(this.jahiaConfig.getTargetServerDirectory() + "/work");
        this.cleanDirectory(toDelete2);
        this.getLogger().info("Finished deleting content of Tomcat's " + toDelete1 + " and " + toDelete2 + " folders");
    }

    private void deleteRepositoryAndIndexes() {
        try {
            File[] files = new File(this.getDataDir(), "repository").listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name == null || !name.startsWith("indexing_configuration") || !name.endsWith(".xml");
                }
            });
            if (files != null) {
                for (File file : files) {
                    FileUtils.forceDelete((File)file);
                }
            }
        }
        catch (IOException e) {
            this.getLogger().error("Error deleting content of the Jahia's /repository folder. Cause: " + e.getMessage(), e);
        }
        this.deleteDirectory(new File(this.getDataDir(), "bundles-deployed"));
        this.deleteDirectory(new File(this.getDataDir(), "compiledRules"));
        this.deleteDirectory(new File(this.getDataDir(), "content"));
        this.deleteDirectory(new File(this.getDataDir(), "generated-resources"));
        this.deleteDirectory(new File(new File(this.getDataDir(), "karaf"), "instances"));
        this.cleanDirectory(new File(new File(this.getDataDir(), "karaf"), "data"));
        this.cleanDirectory(new File(new File(this.getDataDir(), "karaf"), "deploy"));
        this.getLogger().info("Finished deleting content of the data and cache related folders");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyLicense(String fromFileName, String toFileName) throws IOException {
        File fromFile = new File(fromFileName);
        File toFile = new File(toFileName);
        if (!fromFile.exists()) {
            return;
        }
        if (!fromFile.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + fromFileName);
        }
        if (!fromFile.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + fromFileName);
        }
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException iOException) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(String fromFileName, String toFileName) throws IOException {
        File fromFile = new File(fromFileName);
        File toFile = new File(toFileName);
        if (!fromFile.exists()) {
            throw new IOException("FileCopy: no such source file: " + fromFileName);
        }
        if (!fromFile.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + fromFileName);
        }
        if (!fromFile.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + fromFileName);
        }
        toFile.mkdir();
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException iOException) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void createDBTables(File dbScript) throws Exception {
        List<String> sqlStatements = DatabaseScripts.getSchemaSQL(dbScript);
        org.jahia.commons.DatabaseScripts.executeStatements(sqlStatements, (Connection)this.db.getConnection());
    }

    public static String encryptPassword(String password) {
        return EncryptionUtils.pbkdf2Digest((String)password, (boolean)true);
    }

    protected String getWebappDeploymentDirName() {
        return this.jahiaConfig.getWebAppDirName() != null ? this.jahiaConfig.getWebAppDirName() : "jahia";
    }

    protected File getWebappDeploymentDir() {
        if (StringUtils.isNotEmpty((String)this.jahiaConfig.getTargetConfigurationDirectory())) {
            return new File(this.jahiaConfig.getTargetConfigurationDirectory());
        }
        String jeeApplicationLocation = this.jahiaConfig.getJeeApplicationLocation();
        if (!StringUtils.isEmpty((String)jeeApplicationLocation)) {
            return new File(jeeApplicationLocation, "jahia.war");
        }
        return this.getDeployer().getDeploymentDirPath(StringUtils.defaultString((Object)this.getDeployer().getWebappDeploymentDirNameOverride(), (String)this.getWebappDeploymentDirName()), "war");
    }

    private ServerDeploymentInterface getDeployer() {
        if (this.deployer == null) {
            this.deployer = ServerDeploymentFactory.getImplementation((String)this.jahiaConfig.getTargetServerType(), (String)this.jahiaConfig.getTargetServerVersion(), (File)new File(this.jahiaConfig.getTargetServerDirectory()), null, null);
        }
        return this.deployer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JahiaConfigInterface getConfiguration(File configFile, AbstractLogger logger) throws IOException, IllegalAccessException, InvocationTargetException {
        JahiaConfigBean config = new JahiaConfigBean();
        Properties props = null;
        if (configFile != null) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(configFile);
                props = new Properties();
                props.load(is);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        if (props != null && !props.isEmpty()) {
            new BeanUtilsBean(CONVERTER_UTILS_BEAN, new PropertyUtilsBean()).populate((Object)config, (Map)props);
        }
        if (logger != null) {
            props.put("databasePassword", "***");
            props.put("jahiaRootPassword", "***");
            props.put("jahiaToolManagerPassword", "***");
            props.put("mailServer", "***");
            logger.info("Loaded configuration from file " + configFile + ":\n" + props);
        }
        return config;
    }

    private File getDataDir() {
        if (this.dataDir == null) {
            this.dataDir = JahiaGlobalConfigurator.resolveDataDir(this.jahiaConfig.getJahiaVarDiskPath(), this.getWebappDeploymentDir().getAbsolutePath());
            this.getLogger().info("Data directory resolved to folder: " + this.dataDir);
        }
        return this.dataDir;
    }

    static {
        CONVERTER_UTILS_BEAN.register(new Converter(){

            public Object convert(Class type, Object value) {
                return JahiaGlobalConfigurator.fromString(value != null ? value.toString() : null);
            }
        }, List.class);
        CONVERTER_UTILS_BEAN.register(new Converter(){

            public Object convert(Class type, Object value) {
                return value != null ? JahiaGlobalConfigurator.fromJSON(value.toString()) : new HashMap();
            }
        }, Map.class);
    }
}

