/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class DatabaseConnection {
    private Statement theStatement;
    private Connection theConnection;

    public Map databaseTest(String script, String driver, String url, String username, String password, String runtimeSQL, boolean checkUTF8Compliance, boolean createTables) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("testDatabaseTablesAlreadyExists", Boolean.FALSE);
        hashMap.put("testDatabaseConnectionError", Boolean.FALSE);
        hashMap.put("testDatabaseConnectionMessage", "");
        int testStatus = 2;
        try {
            this.databaseOpen(driver, url, username, password);
            testStatus = 0;
        }
        catch (ClassNotFoundException cnfe) {
            hashMap.put("testDatabaseConnectionError", Boolean.TRUE);
            hashMap.put("testDatabaseConnectionMessage", "Driver class not found: " + driver + cnfe.getLocalizedMessage());
            testStatus = 1;
        }
        catch (SQLException sqle) {
            hashMap.put("testDatabaseConnectionError", Boolean.TRUE);
            hashMap.put("testDatabaseConnectionMessage", "Error while connecting to the database:" + sqle.getLocalizedMessage());
            testStatus = 2;
        }
        if (testStatus == 0) {
            String lowerCaseLine = runtimeSQL.toLowerCase();
            String runtimeTableName = "";
            int tableNamePos = lowerCaseLine.indexOf("create table");
            if (tableNamePos != -1) {
                runtimeTableName = runtimeSQL.substring("create table".length() + tableNamePos, runtimeSQL.indexOf("(")).trim();
            }
            String dbProductName = "";
            if (createTables) {
                this.databaseQuery("DROP TABLE " + runtimeTableName, true);
                testStatus = this.databaseQuery(runtimeSQL.toString(), false);
            }
            if (testStatus == 0 && checkUTF8Compliance) {
                String testField = "Latin : Ma\u00ffliss \u00e9\u00e0\u00fc\u00f6\u00a7\u00a3 / Cyrillic : \u0419\u0416 / Chinese : \u8bed\u8a00";
                try {
                    String testFieldResult;
                    PreparedStatement insertStatement = this.theConnection.prepareStatement("INSERT INTO " + runtimeTableName + "(testfield) VALUES(?)");
                    insertStatement.setString(1, testField);
                    insertStatement.execute();
                    ResultSet rs = this.theStatement.executeQuery("SELECT testfield FROM jahia_db_test");
                    if (rs.next() && !(testFieldResult = rs.getString("testfield")).equals(testField)) {
                        ++testStatus;
                        hashMap.put("testDatabaseConnectionError", Boolean.TRUE);
                        hashMap.put("testDatabaseConnectionMessage", "This database doesn't seem to support extended charsets");
                        return hashMap;
                    }
                }
                catch (SQLException sqle) {
                    ++testStatus;
                    hashMap.put("testDatabaseConnectionError", Boolean.TRUE);
                    hashMap.put("testDatabaseConnectionMessage", "This database doesn't seem to support extended charsets");
                }
            }
            if (createTables) {
                testStatus += this.databaseQuery("DROP TABLE " + runtimeTableName, false);
            }
            if (testStatus == 0) {
                try {
                    DatabaseMetaData dbMetaData = this.theConnection.getMetaData();
                    dbProductName = dbMetaData.getDatabaseProductName().trim();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (script.equals("sqlserver.script") && !dbProductName.equals("Microsoft SQL Server")) {
                    testStatus = 1;
                } else if (script.equals("msaccess.script") && !dbProductName.equals("ACCESS")) {
                    testStatus = 1;
                } else if (this.databaseQuery("SELECT * FROM " + runtimeTableName, true) == 0) {
                    hashMap.put("testDatabaseTablesAlreadyExists", Boolean.TRUE);
                }
            }
        }
        if (testStatus == 0) {
            hashMap.put("testDatabaseConnectionError", Boolean.FALSE);
        } else {
            Boolean hasError = (Boolean)hashMap.get("testDatabaseConnectionError");
            if (hasError != null && !hasError.booleanValue() || hasError == null) {
                hashMap.put("testDatabaseConnectionError", Boolean.TRUE);
                hashMap.put("testDatabaseConnectionMessage", "Can't talk with the database. Check your settings.");
            }
        }
        return hashMap;
    }

    public void databaseOpen(String driver, String url, String username, String password) throws ClassNotFoundException, SQLException {
        this.databaseClose();
        Class.forName(driver);
        this.theConnection = DriverManager.getConnection(url, username, password);
        this.theStatement = this.theConnection.createStatement();
    }

    public int databaseQuery(String sqlCode, boolean quietErrors) {
        try {
            this.theStatement.execute(sqlCode);
            return 0;
        }
        catch (Exception e) {
            if (!quietErrors) {
                // empty if block
            }
            return 1;
        }
    }

    public void query(String sqlCode) throws Exception {
        this.theStatement.execute(sqlCode);
    }

    public void queryPreparedStatement(String sqlCode, Object[] params) throws Exception {
        try {
            PreparedStatement ps = this.theConnection.prepareStatement(sqlCode);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException sqle) {
            System.err.println("Error while executing statement : " + sqlCode);
            throw sqle;
        }
    }

    public void databaseClose() {
        try {
            this.theStatement.close();
        }
        catch (SQLException sQLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Connection getConnection() {
        return this.theConnection;
    }

    public Statement getStatement() {
        return this.theStatement;
    }
}

