/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import org.codehaus.plexus.util.StringUtils;
import org.jahia.configuration.configurators.AbstractXMLConfigurator;
import org.jahia.configuration.configurators.ConfigFile;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ApplicationXmlConfigurator
extends AbstractXMLConfigurator {
    private String jeeApplicationModuleList;

    public ApplicationXmlConfigurator(JahiaConfigInterface jahiaConfigInterface, String jeeApplicationModuleListOverride) {
        super(null, jahiaConfigInterface);
        this.jeeApplicationModuleList = StringUtils.defaultString((Object)jeeApplicationModuleListOverride, (String)jahiaConfigInterface.getJeeApplicationModuleList());
    }

    @Override
    public void updateConfiguration(ConfigFile sourceConfigFile, String destFileName) throws Exception {
        if (this.jeeApplicationModuleList == null) {
            return;
        }
        String[] moduleConfigList = this.jeeApplicationModuleList.split(",");
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        InputStreamReader fileReader = new InputStreamReader(sourceConfigFile.getInputStream());
        Document jdomDocument = saxBuilder.build((Reader)fileReader);
        Element root = jdomDocument.getRootElement();
        Namespace ns = root.getNamespace();
        for (String moduleConfig : moduleConfigList) {
            String[] moduleParams = moduleConfig.split(":");
            Element moduleElement = this.getElement(root, "//xp:module[@id=\"" + moduleParams[0] + "\"]");
            Element moduleType = null;
            if (moduleElement != null) {
                moduleType = moduleElement.getChild(moduleParams[1], ns);
                if (moduleType == null) {
                    moduleElement.removeContent();
                }
            } else {
                moduleElement = new Element("module", ns);
                moduleElement.setAttribute("id", moduleParams[0]);
                root.addContent((Content)moduleElement);
            }
            if (moduleType == null) {
                moduleType = new Element(moduleParams[1], ns);
                this.createModuleTypeContent(moduleParams, moduleType);
                moduleElement.addContent((Content)moduleType);
                continue;
            }
            if ("web".equals(moduleParams[1])) {
                Element webUri = moduleType.getChild("web-uri", ns);
                webUri.setText(moduleParams[2]);
                Element contextRoot = moduleType.getChild("context-root", ns);
                if (moduleParams.length < 4 || StringUtils.isEmpty((String)moduleParams[3])) {
                    contextRoot.setText("/");
                    continue;
                }
                contextRoot.setText(moduleParams[3]);
                continue;
            }
            moduleType.setText(moduleParams[2]);
        }
        Format customFormat = Format.getPrettyFormat();
        customFormat.setLineSeparator(System.getProperty("line.separator"));
        XMLOutputter xmlOutputter = new XMLOutputter(customFormat);
        xmlOutputter.output(jdomDocument, (Writer)new FileWriter(destFileName));
    }

    private void createModuleTypeContent(String[] moduleParams, Element moduleType) {
        if ("web".equals(moduleParams[1])) {
            Element webUri = new Element("web-uri", moduleType.getNamespace());
            webUri.setText(moduleParams[2]);
            Element contextRoot = new Element("context-root", moduleType.getNamespace());
            if (moduleParams.length < 4 || StringUtils.isEmpty((String)moduleParams[3])) {
                contextRoot.setText("/");
            } else {
                contextRoot.setText(moduleParams[3]);
            }
            moduleType.addContent((Content)webUri);
            moduleType.addContent((Content)contextRoot);
        } else {
            moduleType.setText(moduleParams[2]);
        }
    }
}

