/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.tasks.admin;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.core.admin.AdminServerTask;
import org.infinispan.server.tasks.admin.SecurityActions;
import org.infinispan.tasks.TaskExecutionMode;

public class LoggingRemoveTask
extends AdminServerTask<byte[]> {
    public String getTaskContextName() {
        return "logging";
    }

    public String getTaskOperationName() {
        return "remove";
    }

    public TaskExecutionMode getExecutionMode() {
        return TaskExecutionMode.ALL_NODES;
    }

    public Set<String> getParameters() {
        return Collections.singleton("loggerName");
    }

    protected byte[] execute(EmbeddedCacheManager cacheManager, Map<String, List<String>> parameters, EnumSet<CacheContainerAdmin.AdminFlag> adminFlags) {
        SecurityActions.checkPermission(cacheManager, AuthorizationPermission.ADMIN);
        String loggerName = this.requireParameter(parameters, "loggerName");
        LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = logContext.getConfiguration();
        if (!configuration.getLoggers().containsKey(loggerName)) {
            throw new NoSuchElementException(loggerName);
        }
        configuration.removeLogger(loggerName);
        logContext.updateLoggers();
        return null;
    }
}

