/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.realm;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.infinispan.server.Server;
import org.infinispan.server.security.ElytronPasswordProviderSupplier;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.RealmEvent;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.cache.RealmIdentityCache;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;

public class CachingSecurityRealm
implements SecurityRealm {
    private final CacheableSecurityRealm realm;
    private final RealmIdentityCache cache;

    public CachingSecurityRealm(CacheableSecurityRealm realm, RealmIdentityCache cache) {
        this.realm = (CacheableSecurityRealm)Assert.checkNotNullParam((String)"realm", (Object)realm);
        this.cache = (RealmIdentityCache)Assert.checkNotNullParam((String)"cache", (Object)cache);
        CacheableSecurityRealm cacheable = realm;
        cacheable.registerIdentityChangeListener(this::removeFromCache);
    }

    public RealmIdentity getRealmIdentity(final Principal principal) throws RealmUnavailableException {
        RealmIdentity cached = this.cache.get(principal);
        if (cached != null) {
            if (Server.log.isTraceEnabled()) {
                Server.log.tracef("Returning cached RealmIdentity for '%s'", principal);
            }
            return cached;
        }
        final RealmIdentity realmIdentity = this.getCacheableRealm().getRealmIdentity(principal);
        if (!realmIdentity.exists()) {
            if (Server.log.isTraceEnabled()) {
                Server.log.tracef("RealmIdentity for '%s' does not exist, skipping cache.'", principal);
            }
            return realmIdentity;
        }
        RealmIdentity cachedIdentity = new RealmIdentity(){
            final RealmIdentity identity;
            AuthorizationIdentity authorizationIdentity;
            Attributes attributes;
            IdentityCredentials credentials;
            int verifiedEvidenceHash;
            {
                this.identity = realmIdentity;
                this.authorizationIdentity = null;
                this.attributes = null;
                this.credentials = IdentityCredentials.NONE;
            }

            public Principal getRealmIdentityPrincipal() {
                return this.identity.getRealmIdentityPrincipal();
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                if (this.credentials.contains(credentialType, algorithmName, parameterSpec)) {
                    if (Server.log.isTraceEnabled()) {
                        Server.log.tracef("getCredentialAcquireSupport credentialType='%s' with algorithmName='%' known for pincipal='%s'", credentialType.getName(), algorithmName, principal.getName());
                    }
                    return this.credentials.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
                }
                Credential credential = this.identity.getCredential(credentialType, algorithmName, parameterSpec);
                if (credential != null) {
                    if (Server.log.isTraceEnabled()) {
                        Server.log.tracef("getCredentialAcquireSupport Credential for credentialType='%s' with algorithmName='%' obtained from identity - caching for principal='%s'", credentialType.getName(), algorithmName, principal.getName());
                    }
                    this.credentials = this.credentials.withCredential(credential);
                }
                return this.credentials.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                if (this.credentials.contains(credentialType)) {
                    if (Server.log.isTraceEnabled()) {
                        Server.log.tracef("getCredential credentialType='%s' cached, returning cached credential for principal='%s'", credentialType.getName(), principal.getName());
                    }
                    return (C)this.credentials.getCredential(credentialType);
                }
                Credential credential = this.identity.getCredential(credentialType);
                if (credential != null) {
                    if (Server.log.isTraceEnabled()) {
                        Server.log.tracef("getCredential credentialType='%s' obtained from identity - caching for principal='%s'", credentialType.getName(), principal.getName());
                    }
                    this.credentials = this.credentials.withCredential(credential);
                }
                return (C)this.credentials.getCredential(credentialType);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
                if (this.credentials.contains(credentialType, algorithmName)) {
                    if (Server.log.isTraceEnabled()) {
                        Server.log.tracef("getCredential credentialType='%s' with algorithmName='%' cached, returning cached credential for principal='%s'", credentialType.getName(), algorithmName, principal.getName());
                    }
                    return (C)this.credentials.getCredential(credentialType, algorithmName);
                }
                Credential credential = this.identity.getCredential(credentialType, algorithmName);
                if (credential != null) {
                    if (Server.log.isTraceEnabled()) {
                        Server.log.tracef("getCredential credentialType='%s' with algorithmName='%' obtained from identity - caching.", credentialType.getName(), algorithmName);
                    }
                    this.credentials = this.credentials.withCredential(credential);
                }
                return (C)this.credentials.getCredential(credentialType, algorithmName);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                if (this.credentials.contains(credentialType, algorithmName, parameterSpec)) {
                    if (Server.log.isTraceEnabled()) {
                        Server.log.tracef("getCredential credentialType='%s' with algorithmName='%s' cached, returning cached credential for principal='%s'", credentialType.getName(), algorithmName, principal.getName());
                    }
                    return (C)this.credentials.getCredential(credentialType, algorithmName, parameterSpec);
                }
                Credential credential = this.identity.getCredential(credentialType, algorithmName, parameterSpec);
                if (credential != null) {
                    if (Server.log.isTraceEnabled()) {
                        Server.log.tracef("getCredential credentialType='%s' with algorithmName='%s' obtained from identity - caching for principal='%s'", credentialType.getName(), algorithmName, principal.getName());
                    }
                    this.credentials = this.credentials.withCredential(credential);
                }
                return (C)this.credentials.getCredential(credentialType, algorithmName, parameterSpec);
            }

            public void updateCredential(Credential credential) throws RealmUnavailableException {
                if (Server.log.isTraceEnabled()) {
                    Server.log.tracef("updateCredential For principal='%s'", principal);
                }
                try {
                    this.identity.updateCredential(credential);
                }
                finally {
                    CachingSecurityRealm.this.removeFromCache(this.identity.getRealmIdentityPrincipal());
                }
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                if (PasswordGuessEvidence.class.isAssignableFrom(evidenceType)) {
                    if (this.credentials.canVerify(evidenceType, algorithmName)) {
                        if (Server.log.isTraceEnabled()) {
                            Server.log.tracef("getEvidenceVerifySupport evidenceType='%s' with algorithmName='%' can verify from cache for principal='%s'", evidenceType.getName(), algorithmName, principal.getName());
                        }
                        return SupportLevel.SUPPORTED;
                    }
                    Credential credential = this.identity.getCredential(PasswordCredential.class);
                    if (credential != null) {
                        if (Server.log.isTraceEnabled()) {
                            Server.log.tracef("getEvidenceVerifySupport evidenceType='%s' with algorithmName='%' credential obtained from identity and cached for principal='%s'", evidenceType.getName(), algorithmName, principal.getName());
                        }
                        this.credentials = this.credentials.withCredential(credential);
                        if (credential.canVerify(evidenceType, algorithmName)) {
                            return SupportLevel.SUPPORTED;
                        }
                    }
                }
                if (Server.log.isTraceEnabled()) {
                    Server.log.tracef("getEvidenceVerifySupport evidenceType='%s' with algorithmName='%' falling back to direct support of identity for principal='%s'", evidenceType.getName(), algorithmName, principal.getName());
                }
                return this.identity.getEvidenceVerifySupport(evidenceType, algorithmName);
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                if (evidence instanceof PasswordGuessEvidence) {
                    char[] guess = ((PasswordGuessEvidence)evidence).getGuess();
                    int evidenceHash = Arrays.hashCode(guess);
                    if (evidenceHash == this.verifiedEvidenceHash) {
                        return true;
                    }
                    if (this.credentials.canVerify(evidence)) {
                        if (Server.log.isTraceEnabled()) {
                            Server.log.tracef("verifyEvidence For principal='%s' using cached credential", principal);
                        }
                        return this.credentials.verify(evidence);
                    }
                    Credential credential = this.identity.getCredential(PasswordCredential.class);
                    if (credential != null) {
                        if (Server.log.isTraceEnabled()) {
                            Server.log.tracef("verifyEvidence Credential obtained from identity and cached for principal='%s'", principal);
                        }
                        this.credentials = this.credentials.withCredential(credential);
                        if (credential.canVerify(evidence)) {
                            boolean res = credential.verify(ElytronPasswordProviderSupplier.INSTANCE, evidence);
                            if (res) {
                                this.verifiedEvidenceHash = evidenceHash;
                            }
                            return res;
                        }
                    }
                    ClearPassword password = ClearPassword.createRaw((String)"clear", (char[])guess);
                    if (Server.log.isTraceEnabled()) {
                        Server.log.tracef("verifyEvidence Falling back to direct support of identity for principal='%s'", principal);
                    }
                    if (this.identity.verifyEvidence(evidence)) {
                        this.credentials = this.credentials.withCredential((Credential)new PasswordCredential((Password)password));
                        return true;
                    }
                    return false;
                }
                return this.identity.verifyEvidence(evidence);
            }

            public boolean exists() throws RealmUnavailableException {
                return true;
            }

            public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                if (this.authorizationIdentity == null) {
                    if (Server.log.isTraceEnabled()) {
                        Server.log.tracef("getAuthorizationIdentity Caching AuthorizationIdentity for principal='%s'", principal);
                    }
                    this.authorizationIdentity = this.identity.getAuthorizationIdentity();
                }
                return this.authorizationIdentity;
            }

            public Attributes getAttributes() throws RealmUnavailableException {
                if (this.attributes == null) {
                    if (Server.log.isTraceEnabled()) {
                        Server.log.tracef("getAttributes Caching Attributes for principal='%s'", principal);
                    }
                    this.attributes = this.identity.getAttributes();
                }
                return this.attributes;
            }

            public void dispose() {
                this.identity.dispose();
            }
        };
        if (Server.log.isTraceEnabled()) {
            Server.log.tracef("Created wrapper RealmIdentity for '%s' and placing in cache.", principal);
        }
        this.cache.put(principal, cachedIdentity);
        return cachedIdentity;
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        return this.getCacheableRealm().getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        return this.getCacheableRealm().getEvidenceVerifySupport(evidenceType, algorithmName);
    }

    public void handleRealmEvent(RealmEvent event) {
        this.getCacheableRealm().handleRealmEvent(event);
    }

    public void removeFromCache(Principal principal) {
        this.cache.remove(principal);
    }

    public void removeAllFromCache() {
        this.cache.clear();
    }

    protected CacheableSecurityRealm getCacheableRealm() {
        return this.realm;
    }
}

