/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.security.GeneralSecurityException;
import java.security.Permission;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.server.configuration.security.FileSystemRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.LocalRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.PropertiesRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmsConfigurationBuilder;
import org.infinispan.server.configuration.security.ServerIdentitiesConfigurationBuilder;
import org.infinispan.server.configuration.security.TokenRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.TrustStoreRealmConfigurationBuilder;
import org.infinispan.server.security.ServerSecurityRealm;
import org.infinispan.server.security.realm.CachingModifiableSecurityRealm;
import org.infinispan.server.security.realm.CachingSecurityRealm;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.cache.LRURealmIdentityCache;
import org.wildfly.security.cache.RealmIdentityCache;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.ssl.SSLContextBuilder;

public class RealmConfigurationBuilder
implements Builder<RealmConfiguration> {
    private final AttributeSet attributes;
    private final SecurityDomain.Builder domainBuilder = SecurityDomain.builder();
    private final RealmsConfigurationBuilder realmsBuilder;
    private final ServerIdentitiesConfigurationBuilder serverIdentitiesConfiguration = new ServerIdentitiesConfigurationBuilder(this);
    private final FileSystemRealmConfigurationBuilder fileSystemConfiguration = new FileSystemRealmConfigurationBuilder(this);
    private final LdapRealmConfigurationBuilder ldapConfiguration = new LdapRealmConfigurationBuilder(this);
    private final LocalRealmConfigurationBuilder localConfiguration = new LocalRealmConfigurationBuilder();
    private final TokenRealmConfigurationBuilder tokenConfiguration = new TokenRealmConfigurationBuilder(this);
    private final TrustStoreRealmConfigurationBuilder trustStoreConfiguration = new TrustStoreRealmConfigurationBuilder(this);
    private final PropertiesRealmConfigurationBuilder propertiesRealmConfiguration = new PropertiesRealmConfigurationBuilder(this);
    private SSLContext sslContext = null;
    private SSLContextBuilder sslContextBuilder = null;
    private Supplier<Boolean> httpChallengeReadiness = () -> true;
    private ServerSecurityRealm serverSecurityRealm = null;
    private EnumSet<ServerSecurityRealm.Feature> features = EnumSet.noneOf(ServerSecurityRealm.Feature.class);
    private RealmIdentityCache cache;

    RealmConfigurationBuilder(String name, RealmsConfigurationBuilder realmsBuilder) {
        this.realmsBuilder = realmsBuilder;
        this.attributes = RealmConfiguration.attributeDefinitionSet();
        this.domainBuilder.setPermissionMapper((principal, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        this.attributes.attribute(RealmConfiguration.NAME).set((Object)name);
    }

    RealmsConfigurationBuilder realmsBuilder() {
        return this.realmsBuilder;
    }

    SSLContextBuilder sslContextBuilder() {
        if (this.sslContextBuilder == null) {
            this.sslContextBuilder = new SSLContextBuilder();
        }
        return this.sslContextBuilder;
    }

    SecurityDomain.Builder domainBuilder() {
        return this.domainBuilder;
    }

    public RealmConfigurationBuilder cacheMaxSize(int size) {
        this.attributes.attribute(RealmConfiguration.CACHE_MAX_SIZE).set((Object)size);
        return this;
    }

    public RealmConfigurationBuilder cacheLifespan(long lifespan) {
        this.attributes.attribute(RealmConfiguration.CACHE_LIFESPAN).set((Object)lifespan);
        return this;
    }

    public FileSystemRealmConfigurationBuilder fileSystemConfiguration() {
        return this.fileSystemConfiguration;
    }

    public LdapRealmConfigurationBuilder ldapConfiguration() {
        return this.ldapConfiguration;
    }

    public LocalRealmConfigurationBuilder localConfiguration() {
        return this.localConfiguration;
    }

    public TokenRealmConfigurationBuilder tokenConfiguration() {
        return this.tokenConfiguration;
    }

    public TrustStoreRealmConfigurationBuilder trustStoreConfiguration() {
        return this.trustStoreConfiguration;
    }

    public ServerIdentitiesConfigurationBuilder serverIdentitiesConfiguration() {
        return this.serverIdentitiesConfiguration;
    }

    public PropertiesRealmConfigurationBuilder propertiesRealm() {
        return this.propertiesRealmConfiguration;
    }

    void setHttpChallengeReadiness(Supplier<Boolean> readiness) {
        this.httpChallengeReadiness = readiness;
    }

    public void validate() {
        this.fileSystemConfiguration.validate();
        this.ldapConfiguration.validate();
        this.localConfiguration.validate();
        this.tokenConfiguration.validate();
        this.trustStoreConfiguration.validate();
        this.serverIdentitiesConfiguration.validate();
        this.propertiesRealmConfiguration.validate();
    }

    public RealmConfiguration create() {
        return new RealmConfiguration(this.attributes.protect(), this.fileSystemConfiguration.create(), this.ldapConfiguration.create(), this.localConfiguration.create(), this.tokenConfiguration.create(), this.trustStoreConfiguration.create(), this.serverIdentitiesConfiguration.create(), this.propertiesRealmConfiguration.create());
    }

    public RealmConfigurationBuilder read(RealmConfiguration template) {
        this.attributes.read(template.attributes());
        this.fileSystemConfiguration.read(template.fileSystemConfiguration());
        this.ldapConfiguration.read(template.ldapConfiguration());
        this.localConfiguration.read(template.localConfiguration());
        this.tokenConfiguration.read(template.tokenConfiguration());
        this.trustStoreConfiguration.read(template.trustStoreConfiguration());
        this.serverIdentitiesConfiguration.read(template.serverIdentitiesConfiguration());
        this.propertiesRealmConfiguration.read(template.propertiesRealm());
        return this;
    }

    ServerSecurityRealm getServerSecurityRealm() {
        if (this.serverSecurityRealm == null) {
            SecurityDomain securityDomain = this.domainBuilder.build();
            String name = (String)this.attributes.attribute(RealmConfiguration.NAME).get();
            this.serverSecurityRealm = new ServerSecurityRealm(name, securityDomain, this.httpChallengeReadiness, this.serverIdentitiesConfiguration.create(), this.features);
        }
        return this.serverSecurityRealm;
    }

    SSLContext getSSLContext() {
        if (this.sslContextBuilder == null) {
            return null;
        }
        if (this.sslContext == null) {
            if (this.features.contains((Object)ServerSecurityRealm.Feature.TRUST)) {
                this.sslContextBuilder.setSecurityDomain(this.getServerSecurityRealm().getSecurityDomain());
            }
            this.sslContextBuilder.setWrap(false);
            String sslProvider = SslContextFactory.getSslProvider();
            if (sslProvider != null) {
                this.sslContextBuilder.setProviderName(sslProvider);
            }
            try {
                this.sslContext = (SSLContext)this.sslContextBuilder.build().create();
            }
            catch (GeneralSecurityException e) {
                throw new CacheConfigurationException((Exception)e);
            }
        }
        return this.sslContext;
    }

    public void addFeature(ServerSecurityRealm.Feature feature) {
        this.features.add(feature);
    }

    private SecurityRealm cacheable(SecurityRealm realm) {
        int maxEntries = (Integer)this.attributes.attribute(RealmConfiguration.CACHE_MAX_SIZE).get();
        if (maxEntries > 0 && realm instanceof CacheableSecurityRealm) {
            if (this.cache == null) {
                this.cache = new LRURealmIdentityCache(maxEntries, ((Long)this.attributes.attribute(RealmConfiguration.CACHE_LIFESPAN).get()).longValue());
            }
            if (realm instanceof ModifiableSecurityRealm) {
                return new CachingModifiableSecurityRealm((CacheableSecurityRealm)realm, this.cache);
            }
            return new CachingSecurityRealm((CacheableSecurityRealm)realm, this.cache);
        }
        return realm;
    }

    public void addRealm(String realmName, SecurityRealm realm) {
        this.addRealm(realmName, realm, null);
    }

    public void addRealm(String realmName, SecurityRealm realm, Consumer<SecurityDomain.RealmBuilder> realmBuilderConsumer) {
        SecurityDomain.RealmBuilder realmBuilder = this.domainBuilder.addRealm(realmName, this.cacheable(realm));
        if (realmBuilderConsumer != null) {
            realmBuilderConsumer.accept(realmBuilder);
        }
        realmBuilder.build();
        if (this.domainBuilder.getDefaultRealmName() == null) {
            this.domainBuilder.setDefaultRealmName(realmName);
        }
    }
}

