/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.PasswordSerializer;
import org.infinispan.server.configuration.security.KeyStoreConfiguration;

public class OAuth2Configuration
implements ConfigurationInfo {
    static final AttributeDefinition<String> CLIENT_ID = AttributeDefinition.builder((String)"clientId", null, String.class).build();
    static final AttributeDefinition<String> CLIENT_SECRET = AttributeDefinition.builder((String)"clientSecret", null, String.class).serializer((AttributeSerializer)PasswordSerializer.INSTANCE).build();
    static final AttributeDefinition<String> CLIENT_SSL_CONTEXT = AttributeDefinition.builder((String)"clientSslContext", null, String.class).build();
    static final AttributeDefinition<String> HOST_VERIFICATION_POLICY = AttributeDefinition.builder((String)"hostNameVerificationPolicy", null, String.class).build();
    static final AttributeDefinition<String> INTROSPECTION_URL = AttributeDefinition.builder((String)"introspectionUrl", null, String.class).build();
    private static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.OAUTH2_INTROSPECTION.toString());
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(KeyStoreConfiguration.class, new AttributeDefinition[]{CLIENT_ID, CLIENT_SECRET, INTROSPECTION_URL, HOST_VERIFICATION_POLICY});
    }

    OAuth2Configuration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String clientId() {
        return (String)this.attributes.attribute(CLIENT_ID).get();
    }
}

