/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.Collections;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.AddressConfiguration;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.network.NetworkAddress;

public class InterfaceConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", null, String.class).build();
    private final AddressConfiguration addressConfiguration;
    private final NetworkAddress networkAddress;
    private static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.INTERFACE.toString());
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(InterfaceConfiguration.class, new AttributeDefinition[]{NAME});
    }

    InterfaceConfiguration(AttributeSet attributes, AddressConfiguration addressConfiguration, NetworkAddress networkAddress) {
        this.attributes = attributes.checkProtection();
        this.addressConfiguration = addressConfiguration;
        this.networkAddress = networkAddress;
    }

    AddressConfiguration addressConfiguration() {
        return this.addressConfiguration;
    }

    public List<ConfigurationInfo> subElements() {
        return Collections.singletonList(this.addressConfiguration);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    NetworkAddress getNetworkAddress() {
        return this.networkAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterfaceConfiguration that = (InterfaceConfiguration)o;
        if (!this.addressConfiguration.equals(that.addressConfiguration)) {
            return false;
        }
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        int result = this.addressConfiguration.hashCode();
        result = 31 * result + this.attributes.hashCode();
        return result;
    }
}

