/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import org.infinispan.commons.CacheException;

class WeakClassLoader
extends ClassLoader {
    private final WeakReference<ClassLoader> loaderRef;

    public WeakClassLoader(ClassLoader classLoader) {
        super(null);
        this.loaderRef = new WeakReference<ClassLoader>(classLoader);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ClassLoader loader = this.requireClassLoader();
        return loader.loadClass(name);
    }

    @Override
    protected URL findResource(String name) {
        ClassLoader loader = this.requireClassLoader();
        return loader.getResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ClassLoader loader = this.requireClassLoader();
        return loader.getResources(name);
    }

    private ClassLoader requireClassLoader() {
        ClassLoader loader = (ClassLoader)this.loaderRef.get();
        if (loader == null) {
            throw new CacheException("ClassLoader reference was garbage collected");
        }
        return loader;
    }
}

