/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.jcache.embedded.JCacheWriterAdapterConfigurationBuilder;
import org.infinispan.jcache.embedded.JStoreAdapterConfigurationBuilder;

public class ConfigurationAdapter<K, V> {
    private MutableConfiguration<K, V> c;

    private ConfigurationAdapter(MutableConfiguration<K, V> configuration) {
        this.c = configuration;
    }

    public MutableConfiguration<K, V> getConfiguration() {
        return this.c;
    }

    public Configuration build() {
        return this.build(new ConfigurationBuilder());
    }

    public Configuration build(Configuration baseConfig) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        if (baseConfig != null) {
            builder.read(baseConfig);
        }
        return this.build(builder);
    }

    private Configuration build(ConfigurationBuilder cb) {
        Factory cacheWriterFactory;
        Factory cacheLoaderFactory;
        if (this.c.isStoreByValue()) {
            cb.memory().storageType(StorageType.BINARY);
        }
        if ((cacheLoaderFactory = this.c.getCacheLoaderFactory()) != null) {
            cb.persistence().addStore(JStoreAdapterConfigurationBuilder.class);
        }
        if ((cacheWriterFactory = this.c.getCacheWriterFactory()) != null) {
            cb.persistence().addStore(JCacheWriterAdapterConfigurationBuilder.class);
        }
        if (this.c.isStatisticsEnabled()) {
            cb.jmxStatistics().enable();
        }
        return cb.build();
    }

    public static <K, V> ConfigurationAdapter<K, V> create(javax.cache.configuration.Configuration<K, V> c) {
        if (c instanceof CompleteConfiguration) {
            return new ConfigurationAdapter<K, V>(new MutableConfiguration((CompleteConfiguration)c));
        }
        MutableConfiguration mutableConfiguration = new MutableConfiguration();
        mutableConfiguration.setStoreByValue(c.isStoreByValue());
        mutableConfiguration.setTypes(c.getKeyType(), c.getValueType());
        return new ConfigurationAdapter<K, V>(new MutableConfiguration((CompleteConfiguration)mutableConfiguration));
    }

    public static <K, V> ConfigurationAdapter<K, V> create() {
        return new ConfigurationAdapter<K, V>(new MutableConfiguration());
    }
}

