/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.Synchronization;
import org.hibernate.HibernateException;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.infinispan.hibernate.cache.commons.access.SessionAccess;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;

public abstract class InvocationAfterCompletion
implements Synchronization {
    protected static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(InvocationAfterCompletion.class);
    protected final SessionAccess.TransactionCoordinatorAccess tc;
    protected final boolean requiresTransaction;

    public InvocationAfterCompletion(SessionAccess.TransactionCoordinatorAccess tc, boolean requiresTransaction) {
        this.tc = tc;
        this.requiresTransaction = requiresTransaction;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        switch (status) {
            case 3: 
            case 8: {
                this.invokeIsolated(true);
                break;
            }
            default: {
                this.invokeIsolated(false);
            }
        }
    }

    protected void invokeIsolated(final boolean success) {
        block2: {
            try {
                this.tc.createIsolationDelegate().delegateWork((WorkExecutorVisitable)new WorkExecutorVisitable<Void>(){

                    public Void accept(WorkExecutor<Void> executor, Connection connection) throws SQLException {
                        InvocationAfterCompletion.this.invoke(success);
                        return null;
                    }
                }, this.requiresTransaction);
            }
            catch (HibernateException e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace("Exception during query cache update", e);
            }
        }
    }

    protected abstract void invoke(boolean var1);
}

