/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;

public class TestResourceTracker {
    private static final Logger log = Logger.getLogger(TestResourceTracker.class);
    private static final ConcurrentMap<String, TestResources> testResources = new ConcurrentHashMap<String, TestResources>();
    private static final ThreadLocal<String> threadTestName = new InheritableThreadLocal<String>();

    public static void addResource(String testName, Cleaner<?> cleaner) {
        TestResources resources = TestResourceTracker.getTestResources(testName);
        resources.addResource(cleaner);
    }

    public static void addResource(Cleaner<?> cleaner) {
        String testName = TestResourceTracker.getCurrentTestName();
        TestResourceTracker.addResource(testName, cleaner);
    }

    public static void cleanUpResources(String testName) {
        TestResources resources = (TestResources)testResources.remove(testName);
        if (resources != null) {
            for (Cleaner<?> cleaner : resources.getCleaners()) {
                try {
                    cleaner.close();
                }
                catch (Throwable t) {
                    log.fatalf(t, "Error cleaning resource %s for test %s", cleaner.ref, (Object)testName);
                    throw new IllegalStateException("Error cleaning resource " + String.valueOf(cleaner.ref) + " for test " + testName, t);
                }
            }
        }
    }

    public static String getCurrentTestShortName() {
        String currentTestName = TestResourceTracker.getCurrentTestName();
        return TestResourceTracker.getTestResources(currentTestName).getShortName();
    }

    public static String getCurrentTestName() {
        String testName = threadTestName.get();
        if (testName == null) {
            String threadName = Thread.currentThread().getName();
            if (threadName.equals("main") || threadName.equals("TestNG")) {
                throw new IllegalStateException("Test name is not set! Please extend AbstractInfinispanTest!");
            }
            if (threadName.startsWith("TestNGInvoker-")) {
                throw new IllegalStateException("Test name is not set! Please call TestResourceTracker.testThreadStarted(this.getTestName()) in your test method!");
            }
            throw new IllegalStateException("Test name is not set! Please call TestResourceTracker.testThreadStarted(this.getTestName()) in thread " + threadName + " !");
        }
        return testName;
    }

    public static void testStarted(String testName) {
        if (testResources.containsKey(testName)) {
            throw new IllegalStateException("Two tests with the same name running in parallel: " + testName);
        }
        TestResourceTracker.setThreadTestName(testName);
        Thread.currentThread().setName(TestResourceTracker.getNextTestThreadName());
    }

    public static void testFinished(String testName) {
        TestResourceTracker.cleanUpResources(testName);
        if (!testName.equals(threadTestName.get())) {
            TestResourceTracker.cleanUpResources(TestResourceTracker.getCurrentTestName());
            throw new IllegalArgumentException("Current thread's test name was not set correctly: " + TestResourceTracker.getCurrentTestName() + ", should have been " + testName);
        }
        TestResourceTracker.setThreadTestName(null);
    }

    public static void testThreadStarted(String testName) {
        TestResourceTracker.setThreadTestName(testName);
        Thread.currentThread().setName(TestResourceTracker.getNextTestThreadName());
    }

    public static void setThreadTestName(String testName) {
        threadTestName.set(testName);
    }

    public static void setThreadTestNameIfMissing(String testName) {
        if (threadTestName.get() == null) {
            threadTestName.set(testName);
        }
    }

    public static String getNextNodeName() {
        String testName = TestResourceTracker.getCurrentTestName();
        TestResources resources = TestResourceTracker.getTestResources(testName);
        String shortName = resources.getShortName();
        int nextNodeIndex = resources.addNode();
        return shortName + "-Node" + TestResourceTracker.getNameForIndex(nextNodeIndex);
    }

    public static String getNextTestThreadName() {
        String testName = TestResourceTracker.getCurrentTestName();
        TestResources resources = TestResourceTracker.getTestResources(testName);
        String shortName = resources.getShortName();
        int nextThreadIndex = resources.addThread();
        return "testng-" + shortName + (String)(nextThreadIndex != 0 ? "-" + nextThreadIndex : "");
    }

    public static String getNameForIndex(int i) {
        int k = 26;
        String c = String.valueOf((char)(65 + i % 26));
        int q = i / 26;
        return q == 0 ? c : TestResourceTracker.getNameForIndex(q - 1) + c;
    }

    private static TestResources getTestResources(String testName) {
        return testResources.computeIfAbsent(testName, x$0 -> new TestResources((String)x$0));
    }

    private static class TestResources {
        private static final boolean shortenTestName = Boolean.getBoolean("infinispan.test.shortTestName");
        private final String shortName;
        private final AtomicInteger nodeCount = new AtomicInteger(0);
        private final AtomicInteger threadCount = new AtomicInteger(0);
        private final List<Cleaner<?>> resourceCleaners = Collections.synchronizedList(new ArrayList());

        private TestResources(String testName) {
            if (shortenTestName) {
                this.shortName = "Test";
            } else {
                int simpleNameStart = testName.lastIndexOf(".");
                int parametersStart = testName.indexOf(91);
                this.shortName = testName.substring(simpleNameStart + 1, parametersStart > 0 ? parametersStart : testName.length());
            }
        }

        public String getShortName() {
            return this.shortName;
        }

        public int addNode() {
            return this.nodeCount.getAndIncrement();
        }

        public int addThread() {
            return this.threadCount.getAndIncrement();
        }

        public void addResource(Cleaner<?> cleaner) {
            this.resourceCleaners.add(cleaner);
        }

        public List<Cleaner<?>> getCleaners() {
            return this.resourceCleaners;
        }
    }

    public static abstract class Cleaner<T> {
        protected final T ref;

        protected Cleaner(T ref) {
            this.ref = ref;
        }

        public abstract void close();
    }
}

