/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.configuration;

import java.util.Collections;
import java.util.Map;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.counter.configuration.AbstractCounterConfiguration;
import org.infinispan.counter.configuration.Attribute;
import org.infinispan.counter.configuration.CounterConfigurationSerializer;
import org.infinispan.counter.configuration.Element;
import org.infinispan.counter.configuration.Reliability;
import org.infinispan.counter.logging.Log;

@SerializedWith(value=CounterConfigurationSerializer.class)
public class CounterManagerConfiguration
extends ConfigurationElement<CounterManagerConfiguration> {
    static final AttributeDefinition<Reliability> RELIABILITY = AttributeDefinition.builder((String)"reliability", (Object)((Object)Reliability.AVAILABLE)).validator(value -> {
        if (value == null) {
            throw Log.CONTAINER.invalidReliabilityMode();
        }
    }).immutable().build();
    static final AttributeDefinition<Integer> NUM_OWNERS = AttributeDefinition.builder((Enum)Attribute.NUM_OWNERS, (Object)2).validator(value -> {
        if (value < 1) {
            throw Log.CONTAINER.invalidNumOwners((int)value);
        }
    }).immutable().build();
    private final Map<String, AbstractCounterConfiguration> counters;

    CounterManagerConfiguration(AttributeSet attributes, Map<String, AbstractCounterConfiguration> counters) {
        super((Enum)Element.COUNTERS, attributes, new ConfigurationElement[0]);
        this.counters = counters;
    }

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(CounterManagerConfiguration.class, new AttributeDefinition[]{NUM_OWNERS, RELIABILITY});
    }

    public int numOwners() {
        return (Integer)this.attributes.attribute(NUM_OWNERS).get();
    }

    public Reliability reliability() {
        return (Reliability)((Object)this.attributes.attribute(RELIABILITY).get());
    }

    public Map<String, AbstractCounterConfiguration> counters() {
        return Collections.unmodifiableMap(this.counters);
    }
}

