/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.printers;

import java.io.IOException;
import java.util.Map;
import org.aesh.command.shell.Shell;
import org.infinispan.cli.printers.PrettyPrinter;
import org.infinispan.cli.printers.PrettyRowPrinter;

public class TablePrettyPrinter
implements PrettyPrinter {
    private final Shell shell;
    private final PrettyRowPrinter rowPrinter;
    private boolean header = true;

    public TablePrettyPrinter(Shell shell, PrettyRowPrinter rowPrinter) {
        this.shell = shell;
        this.rowPrinter = rowPrinter;
    }

    @Override
    public void printItem(Map<String, String> item) {
        int cols = item.size();
        if (this.rowPrinter.showHeader() && this.header) {
            for (int row = 0; row < 2; ++row) {
                for (int col = 0; col < cols; ++col) {
                    if (col > 0) {
                        this.shell.write(row == 0 ? "|" : "+");
                    }
                    if (row == 0) {
                        String format = "%-" + this.rowPrinter.columnWidth(col) + "s";
                        this.shell.write(String.format(format, this.rowPrinter.columnHeader(col)));
                        continue;
                    }
                    this.shell.write("-".repeat(this.rowPrinter.columnWidth(col)));
                }
                this.shell.writeln("");
            }
            this.header = false;
        }
        int[] colsWrap = new int[cols];
        int remaining = cols;
        do {
            int i = 0;
            for (Map.Entry<String, String> col : item.entrySet()) {
                if (i > 0) {
                    this.shell.write("|");
                }
                String v = this.rowPrinter.formatColumn(i, col.getValue());
                int width = this.rowPrinter.columnWidth(i);
                String format = "%-" + width + "s";
                if (i < 4) {
                    if (colsWrap[i] < 0) {
                        v = "";
                    } else if (v.length() - colsWrap[i] > width) {
                        v = v.substring(colsWrap[i], colsWrap[i] + width);
                        int n = i;
                        colsWrap[n] = colsWrap[n] + width;
                    } else {
                        v = v.substring(colsWrap[i]);
                        colsWrap[i] = -1;
                        --remaining;
                    }
                    this.shell.write(String.format(format, v));
                } else if (colsWrap[i] == 0) {
                    this.shell.write(String.format(format, v));
                    colsWrap[i] = -1;
                    --remaining;
                } else {
                    this.shell.write(" ".repeat(width));
                }
                ++i;
            }
            this.shell.writeln("");
        } while (remaining > 0);
    }

    @Override
    public void close() throws IOException {
    }
}

