package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Round}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRound.builder()}.
 */
@Generated(from = "Round", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableRound extends Round {
  private final ProcessingEnvironment processing;
  private final RoundEnvironment round;
  private final ImmutableSet<TypeElement> annotations;
  private final ImmutableSet<String> customImmutableAnnotations;
  private transient final ValueTypeComposer composer;

  private ImmutableRound(
      ProcessingEnvironment processing,
      RoundEnvironment round,
      ImmutableSet<TypeElement> annotations,
      ImmutableSet<String> customImmutableAnnotations) {
    this.processing = processing;
    this.round = round;
    this.annotations = annotations;
    this.customImmutableAnnotations = customImmutableAnnotations;
    this.composer = Objects.requireNonNull(super.composer(), "composer");
  }

  /**
   * @return The value of the {@code processing} attribute
   */
  @Override
  public ProcessingEnvironment processing() {
    return processing;
  }

  /**
   * @return The value of the {@code round} attribute
   */
  @Override
  public RoundEnvironment round() {
    return round;
  }

  /**
   * @return The value of the {@code annotations} attribute
   */
  @Override
  public ImmutableSet<TypeElement> annotations() {
    return annotations;
  }

  /**
   * @return The value of the {@code customImmutableAnnotations} attribute
   */
  @Override
  public ImmutableSet<String> customImmutableAnnotations() {
    return customImmutableAnnotations;
  }

  /**
   * @return The computed-at-construction value of the {@code composer} attribute
   */
  @Override
  ValueTypeComposer composer() {
    return composer;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Round#processing() processing} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processing
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRound withProcessing(ProcessingEnvironment value) {
    if (this.processing == value) return this;
    ProcessingEnvironment newValue = Objects.requireNonNull(value, "processing");
    return new ImmutableRound(newValue, this.round, this.annotations, this.customImmutableAnnotations);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Round#round() round} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for round
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRound withRound(RoundEnvironment value) {
    if (this.round == value) return this;
    RoundEnvironment newValue = Objects.requireNonNull(value, "round");
    return new ImmutableRound(this.processing, newValue, this.annotations, this.customImmutableAnnotations);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Round#annotations() annotations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRound withAnnotations(TypeElement... elements) {
    ImmutableSet<TypeElement> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableRound(this.processing, this.round, newValue, this.customImmutableAnnotations);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Round#annotations() annotations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of annotations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRound withAnnotations(Iterable<? extends TypeElement> elements) {
    if (this.annotations == elements) return this;
    ImmutableSet<TypeElement> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableRound(this.processing, this.round, newValue, this.customImmutableAnnotations);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Round#customImmutableAnnotations() customImmutableAnnotations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRound withCustomImmutableAnnotations(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableRound(this.processing, this.round, this.annotations, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Round#customImmutableAnnotations() customImmutableAnnotations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of customImmutableAnnotations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRound withCustomImmutableAnnotations(Iterable<String> elements) {
    if (this.customImmutableAnnotations == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableRound(this.processing, this.round, this.annotations, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRound} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRound
        && equalTo((ImmutableRound) another);
  }

  private boolean equalTo(ImmutableRound another) {
    return processing.equals(another.processing)
        && round.equals(another.round)
        && annotations.equals(another.annotations)
        && customImmutableAnnotations.equals(another.customImmutableAnnotations)
        && composer.equals(another.composer);
  }

  /**
   * Computes a hash code from attributes: {@code processing}, {@code round}, {@code annotations}, {@code customImmutableAnnotations}, {@code composer}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + processing.hashCode();
    h += (h << 5) + round.hashCode();
    h += (h << 5) + annotations.hashCode();
    h += (h << 5) + customImmutableAnnotations.hashCode();
    h += (h << 5) + composer.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Round} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Round")
        .omitNullValues()
        .add("processing", processing)
        .add("round", round)
        .add("annotations", annotations)
        .add("customImmutableAnnotations", customImmutableAnnotations)
        .add("composer", composer)
        .toString();
  }

  private transient volatile long lazyInitBitmap;

  private static final long ENVIRONMENT_LAZY_INIT_BIT = 0x1L;

  private transient Proto.Environment environment;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Round#environment() environment} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code environment} attribute
   */
  @Override
  public Proto.Environment environment() {
    if ((lazyInitBitmap & ENVIRONMENT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & ENVIRONMENT_LAZY_INIT_BIT) == 0) {
          this.environment = Objects.requireNonNull(super.environment(), "environment");
          lazyInitBitmap |= ENVIRONMENT_LAZY_INIT_BIT;
        }
      }
    }
    return environment;
  }

  /**
   * Creates an immutable copy of a {@link Round} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Round instance
   */
  public static ImmutableRound copyOf(Round instance) {
    if (instance instanceof ImmutableRound) {
      return (ImmutableRound) instance;
    }
    return ImmutableRound.builder()
        .processing(instance.processing())
        .round(instance.round())
        .addAllAnnotations(instance.annotations())
        .addAllCustomImmutableAnnotations(instance.customImmutableAnnotations())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRound ImmutableRound}.
   * <pre>
   * ImmutableRound.builder()
   *    .processing(javax.annotation.processing.ProcessingEnvironment) // required {@link Round#processing() processing}
   *    .round(javax.annotation.processing.RoundEnvironment) // required {@link Round#round() round}
   *    .addAnnotations|addAllAnnotations(javax.lang.model.element.TypeElement) // {@link Round#annotations() annotations} elements
   *    .addCustomImmutableAnnotations|addAllCustomImmutableAnnotations(String) // {@link Round#customImmutableAnnotations() customImmutableAnnotations} elements
   *    .build();
   * </pre>
   * @return A new ImmutableRound builder
   */
  public static ImmutableRound.Builder builder() {
    return new ImmutableRound.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRound ImmutableRound}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Round", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PROCESSING = 0x1L;
    private static final long INIT_BIT_ROUND = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ProcessingEnvironment processing;
    private @Nullable RoundEnvironment round;
    private final ImmutableSet.Builder<TypeElement> annotations = ImmutableSet.builder();
    private final ImmutableSet.Builder<String> customImmutableAnnotations = ImmutableSet.builder();

    private Builder() {
    }

    /**
     * Initializes the value for the {@link Round#processing() processing} attribute.
     * @param processing The value for processing 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processing(ProcessingEnvironment processing) {
      checkNotIsSet(processingIsSet(), "processing");
      this.processing = Objects.requireNonNull(processing, "processing");
      initBits &= ~INIT_BIT_PROCESSING;
      return this;
    }

    /**
     * Initializes the value for the {@link Round#round() round} attribute.
     * @param round The value for round 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder round(RoundEnvironment round) {
      checkNotIsSet(roundIsSet(), "round");
      this.round = Objects.requireNonNull(round, "round");
      initBits &= ~INIT_BIT_ROUND;
      return this;
    }

    /**
     * Adds one element to {@link Round#annotations() annotations} set.
     * @param element A annotations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAnnotations(TypeElement element) {
      this.annotations.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Round#annotations() annotations} set.
     * @param elements An array of annotations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAnnotations(TypeElement... elements) {
      this.annotations.add(elements);
      return this;
    }


    /**
     * Adds elements to {@link Round#annotations() annotations} set.
     * @param elements An iterable of annotations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAnnotations(Iterable<? extends TypeElement> elements) {
      this.annotations.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Round#customImmutableAnnotations() customImmutableAnnotations} set.
     * @param element A customImmutableAnnotations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCustomImmutableAnnotations(String element) {
      this.customImmutableAnnotations.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Round#customImmutableAnnotations() customImmutableAnnotations} set.
     * @param elements An array of customImmutableAnnotations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addCustomImmutableAnnotations(String... elements) {
      this.customImmutableAnnotations.add(elements);
      return this;
    }


    /**
     * Adds elements to {@link Round#customImmutableAnnotations() customImmutableAnnotations} set.
     * @param elements An iterable of customImmutableAnnotations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllCustomImmutableAnnotations(Iterable<String> elements) {
      this.customImmutableAnnotations.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRound ImmutableRound}.
     * @return An immutable instance of Round
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRound build() {
      checkRequiredAttributes();
      return new ImmutableRound(processing, round, annotations.build(), customImmutableAnnotations.build());
    }

    private boolean processingIsSet() {
      return (initBits & INIT_BIT_PROCESSING) == 0;
    }

    private boolean roundIsSet() {
      return (initBits & INIT_BIT_ROUND) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of Round is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!processingIsSet()) attributes.add("processing");
      if (!roundIsSet()) attributes.add("round");
      return "Cannot build Round, some of required attributes are not set " + attributes;
    }
  }
}
