/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.internal.$guava$.base.$Throwables;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$processor$.encode.$Instantiator;
import org.immutables.value.internal.$processor$.meta.$CachingElements;
import org.immutables.value.internal.$processor$.meta.$DefaultAnnotations;
import org.immutables.value.internal.$processor$.meta.$Proto;
import org.immutables.value.internal.$processor$.meta.$Reporter;
import org.immutables.value.internal.$processor$.meta.$Styles;
import org.immutables.value.internal.$processor$.meta.$ValueAttribute;
import org.immutables.value.internal.$processor$.meta.$ValueType;

final class $RecordComponentCollector {
    private final $Proto.Protoclass protoclass;
    private final $ValueType type;
    private final List<$ValueAttribute> attributes = $Lists.newArrayList();
    private final $Styles styles;
    private final $Reporter reporter;
    @Nullable
    private static final Method GET_RECORD_COMPONENTS;
    @Nullable
    private static final Method GET_RECORD_ACCESSOR;
    private static final String RECORD_COMPONENT_CLASSNAME = "javax.lang.model.element.RecordComponentElement";

    $RecordComponentCollector($Proto.Protoclass protoclass, $ValueType type) {
        this.protoclass = protoclass;
        this.styles = protoclass.styles();
        this.type = type;
        this.reporter = protoclass.report();
    }

    void collect() {
        TypeElement recordType = (TypeElement)this.protoclass.sourceElement();
        for (ExecutableElement accessor : this.recordComponentAssessors(recordType)) {
            TypeMirror returnType = accessor.getReturnType();
            $Reporter reporter = this.report(accessor);
            $ValueAttribute attribute = new $ValueAttribute();
            attribute.isGenerateAbstract = true;
            attribute.reporter = reporter;
            attribute.returnType = returnType;
            attribute.element = accessor;
            String parameterName = accessor.getSimpleName().toString();
            attribute.names = this.styles.forAccessorWithRaw(parameterName, parameterName);
            attribute.constantDefault = $DefaultAnnotations.extractConstantDefault(reporter, accessor, returnType);
            if (attribute.constantDefault != null) {
                attribute.isGenerateDefault = true;
            }
            attribute.containingType = this.type;
            this.attributes.add(attribute);
        }
        $Instantiator encodingInstantiator = this.protoclass.encodingInstantiator();
        $Instantiator.InstantiationCreator instantiationCreator = encodingInstantiator.creatorFor(recordType);
        for ($ValueAttribute attribute : this.attributes) {
            attribute.initAndValidate(instantiationCreator);
        }
        if (instantiationCreator != null) {
            this.type.additionalImports(instantiationCreator.imports);
        }
        this.type.attributes.addAll(this.attributes);
    }

    private List<ExecutableElement> recordComponentAssessors(TypeElement type) {
        if (GET_RECORD_ACCESSOR == null) {
            return Collections.emptyList();
        }
        assert (GET_RECORD_COMPONENTS != null);
        type = $CachingElements.getDelegate(type);
        ArrayList<ExecutableElement> accessors = new ArrayList<ExecutableElement>();
        try {
            List components = (List)GET_RECORD_COMPONENTS.invoke((Object)type, new Object[0]);
            for (Object c : components) {
                ExecutableElement accessor = (ExecutableElement)GET_RECORD_ACCESSOR.invoke(c, new Object[0]);
                accessors.add(accessor);
            }
        }
        catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
            this.reporter.withElement(type).error("Problem with `TypeElement.getRecordComponents.*.getAccessor` from record type mirror, compiler mismatch.\n" + $Throwables.getStackTraceAsString(e), new Object[0]);
        }
        return accessors;
    }

    private $Reporter report(Element type) {
        return $Reporter.from(this.protoclass.processing()).withElement(type);
    }

    static {
        Method getAccessor;
        Method getRecordComponents;
        try {
            Class<?> recordComponentClass = Class.forName(RECORD_COMPONENT_CLASSNAME, true, TypeElement.class.getClassLoader());
            getRecordComponents = TypeElement.class.getMethod("getRecordComponents", new Class[0]);
            getAccessor = recordComponentClass.getMethod("getAccessor", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            getRecordComponents = null;
            getAccessor = null;
        }
        GET_RECORD_COMPONENTS = getRecordComponents;
        GET_RECORD_ACCESSOR = getAccessor;
    }
}

