/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath;

import java.util.Stack;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import org.htmlunit.xpath.axes.SubContextList;
import org.htmlunit.xpath.res.XPATHMessages;
import org.htmlunit.xpath.xml.dtm.DTM;
import org.htmlunit.xpath.xml.dtm.DTMManager;
import org.htmlunit.xpath.xml.utils.DefaultErrorHandler;
import org.htmlunit.xpath.xml.utils.PrefixResolver;
import org.w3c.dom.Node;

public class XPathContext
extends DTMManager {
    protected DTMManager m_dtmManager = DTMManager.newInstance();
    private ErrorListener m_errorListener;
    private ErrorListener m_defaultErrorListener;
    private URIResolver m_uriResolver;
    public static final int RECURSIONLIMIT = 4096;
    private final Stack<Integer> m_currentNodes = new Stack();
    private final Stack<Integer> m_currentExpressionNodes = new Stack();
    private final Stack<Integer> m_predicatePos = new Stack();
    private final Stack<PrefixResolver> m_prefixResolvers = new Stack();
    private final Stack<SubContextList> m_axesIteratorStack = new Stack();

    public DTMManager getDTMManager() {
        return this.m_dtmManager;
    }

    @Override
    public DTM getDTM(Source source, boolean unique, boolean incremental, boolean doIndexing) {
        return this.m_dtmManager.getDTM(source, unique, incremental, doIndexing);
    }

    @Override
    public DTM getDTM(int nodeHandle) {
        return this.m_dtmManager.getDTM(nodeHandle);
    }

    @Override
    public int getDTMHandleFromNode(Node node) {
        return this.m_dtmManager.getDTMHandleFromNode(node);
    }

    public XPathContext() {
        this(true);
    }

    public XPathContext(boolean recursiveVarContext) {
        this.m_prefixResolvers.push(null);
        this.m_currentNodes.push(-1);
        this.m_currentExpressionNodes.push(-1);
    }

    public void reset() {
        this.m_dtmManager = DTMManager.newInstance();
        this.m_axesIteratorStack.removeAllElements();
        this.m_currentExpressionNodes.removeAllElements();
        this.m_currentNodes.removeAllElements();
        this.m_predicatePos.removeAllElements();
        this.m_prefixResolvers.removeAllElements();
        this.m_prefixResolvers.push(null);
        this.m_currentNodes.push(-1);
        this.m_currentExpressionNodes.push(-1);
    }

    public final ErrorListener getErrorListener() {
        if (null != this.m_errorListener) {
            return this.m_errorListener;
        }
        if (null == this.m_defaultErrorListener) {
            this.m_defaultErrorListener = new DefaultErrorHandler();
        }
        return this.m_defaultErrorListener;
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException(XPATHMessages.createXPATHMessage("ER_NULL_ERROR_HANDLER", null));
        }
        this.m_errorListener = listener;
    }

    public final URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this.m_uriResolver = resolver;
    }

    public final int getCurrentNode() {
        return this.m_currentNodes.peek();
    }

    public final void pushCurrentNodeAndExpression(int cn) {
        this.m_currentNodes.push(cn);
        this.m_currentExpressionNodes.push(cn);
    }

    public final void popCurrentNodeAndExpression() {
        this.m_currentNodes.pop();
        this.m_currentExpressionNodes.pop();
    }

    public final void pushCurrentNode(int n) {
        this.m_currentNodes.push(n);
    }

    public final void popCurrentNode() {
        this.m_currentNodes.pop();
    }

    public final int getPredicatePos() {
        return this.m_predicatePos.peek();
    }

    public final void pushPredicatePos(int n) {
        this.m_predicatePos.push(n);
    }

    public final void popPredicatePos() {
        this.m_predicatePos.pop();
    }

    public final PrefixResolver getNamespaceContext() {
        return this.m_prefixResolvers.peek();
    }

    public final void setNamespaceContext(PrefixResolver pr) {
        this.m_prefixResolvers.pop();
        this.m_prefixResolvers.push(pr);
    }

    public final void pushNamespaceContext(PrefixResolver pr) {
        this.m_prefixResolvers.push(pr);
    }

    public final void popNamespaceContext() {
        this.m_prefixResolvers.pop();
    }

    public final void pushSubContextList(SubContextList iter) {
        this.m_axesIteratorStack.push(iter);
    }

    public final void popSubContextList() {
        this.m_axesIteratorStack.pop();
    }

    public SubContextList getSubContextList() {
        return this.m_axesIteratorStack.isEmpty() ? null : this.m_axesIteratorStack.peek();
    }
}

