/*
 * Decompiled with CFR 0.152.
 */
package hprose.net;

import hprose.net.Connection;
import hprose.net.ConnectionHandler;
import hprose.net.ReactorGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public final class Acceptor
extends Thread {
    private final Selector selector = Selector.open();
    private final ServerSocketChannel serverChannel = ServerSocketChannel.open();
    private final ReactorGroup reactor;
    private final ConnectionHandler handler;

    public Acceptor(String host, int port, ConnectionHandler handler, int reactorThreads) throws IOException {
        ServerSocket serverSocket = this.serverChannel.socket();
        InetSocketAddress address = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        serverSocket.bind(address);
        this.serverChannel.configureBlocking(false);
        this.serverChannel.register(this.selector, 16);
        this.reactor = new ReactorGroup(reactorThreads);
        this.handler = handler;
    }

    @Override
    public void run() {
        this.reactor.start();
        try {
            while (!this.isInterrupted()) {
                try {
                    this.process();
                }
                catch (IOException e) {
                    this.handler.onError(null, e);
                }
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            // empty catch block
        }
        this.reactor.close();
    }

    private void process() throws IOException {
        int n = this.selector.select();
        if (n == 0) {
            return;
        }
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            if (!key.isAcceptable()) continue;
            this.accept(key);
        }
    }

    private void accept(SelectionKey key) throws IOException {
        SocketChannel channel = ((ServerSocketChannel)key.channel()).accept();
        if (channel != null) {
            channel.configureBlocking(false);
            channel.socket().setReuseAddress(true);
            channel.socket().setKeepAlive(true);
            this.reactor.register(new Connection(channel, this.handler, null));
        }
    }

    public void close() {
        try {
            this.selector.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.serverChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

