/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.BaseUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.ReferenceReader;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Date;

public final class DateUnserializer
extends BaseUnserializer<Date> {
    public static final DateUnserializer instance = new DateUnserializer();

    @Override
    public Date unserialize(Reader reader, int tag, Type type) throws IOException {
        switch (tag) {
            case 68: {
                return ReferenceReader.readDateTime(reader).toDate();
            }
            case 84: {
                return ReferenceReader.readTime(reader).toDate();
            }
            case 101: {
                return null;
            }
            case 115: {
                return Date.valueOf(ReferenceReader.readString(reader));
            }
            case 105: 
            case 108: {
                return new Date(ValueReader.readLong(reader));
            }
            case 100: {
                return new Date((long)ValueReader.readDouble(reader));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new Date(tag - 48);
        }
        return (Date)super.unserialize(reader, tag, type);
    }

    public Date read(Reader reader) throws IOException {
        return (Date)this.read(reader, (Type)((Object)Date.class));
    }
}

