/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.access;

import hprose.common.HproseException;
import hprose.io.access.Accessors;
import hprose.io.access.MemberAccessor;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.ShortUnserializer;
import java.io.IOException;
import java.lang.reflect.Field;

public final class ShortFieldAccessor
implements MemberAccessor {
    private final long offset;

    public ShortFieldAccessor(Field accessor) {
        accessor.setAccessible(true);
        this.offset = Accessors.unsafe.objectFieldOffset(accessor);
    }

    @Override
    public void serialize(Writer writer, Object obj) throws IOException {
        short value;
        try {
            value = Accessors.unsafe.getShort(obj, this.offset);
        }
        catch (Exception e) {
            throw new HproseException(e.getMessage());
        }
        ValueWriter.write(writer.stream, value);
    }

    @Override
    public void unserialize(Reader reader, Object obj) throws IOException {
        short value = ShortUnserializer.instance.read(reader);
        try {
            Accessors.unsafe.putShort(obj, this.offset, value);
        }
        catch (Exception e) {
            throw new HproseException(e.getMessage());
        }
    }
}

