/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.univariate;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.optim.OptimizationData;
import org.hipparchus.util.MathUtils;

public class SearchInterval
implements OptimizationData {
    private final double lower;
    private final double upper;
    private final double start;

    public SearchInterval(double lo, double hi, double init) {
        if (lo >= hi) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, new Object[]{lo, hi});
        }
        MathUtils.checkRangeInclusive((double)init, (double)lo, (double)hi);
        this.lower = lo;
        this.upper = hi;
        this.start = init;
    }

    public SearchInterval(double lo, double hi) {
        this(lo, hi, 0.5 * (lo + hi));
    }

    public double getMin() {
        return this.lower;
    }

    public double getMax() {
        return this.upper;
    }

    public double getStartValue() {
        return this.start;
    }
}

