/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff.interpolators;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.interpolators.RungeKuttaStateInterpolator;

public class EulerStateInterpolator
extends RungeKuttaStateInterpolator {
    private static final long serialVersionUID = 20160328L;

    public EulerStateInterpolator(boolean forward, double[][] yDotK, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, ODEStateAndDerivative softPreviousState, ODEStateAndDerivative softCurrentState, EquationsMapper mapper) {
        super(forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected EulerStateInterpolator create(boolean newForward, double[][] newYDotK, ODEStateAndDerivative newGlobalPreviousState, ODEStateAndDerivative newGlobalCurrentState, ODEStateAndDerivative newSoftPreviousState, ODEStateAndDerivative newSoftCurrentState, EquationsMapper newMapper) {
        return new EulerStateInterpolator(newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected ODEStateAndDerivative computeInterpolatedStateAndDerivatives(EquationsMapper mapper, double time, double theta, double thetaH, double oneMinusThetaH) {
        double[] interpolatedState = this.getGlobalPreviousState() != null && theta <= 0.5 ? this.previousStateLinearCombination(thetaH) : this.currentStateLinearCombination(-oneMinusThetaH);
        double[] interpolatedDerivatives = this.derivativeLinearCombination(1.0);
        return mapper.mapStateAndDerivative(time, interpolatedState, interpolatedDerivatives);
    }
}

