/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff.interpolators;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.interpolators.RungeKuttaFieldStateInterpolator;

public class ClassicalRungeKuttaFieldStateInterpolator<T extends CalculusFieldElement<T>>
extends RungeKuttaFieldStateInterpolator<T> {
    public ClassicalRungeKuttaFieldStateInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        super(field, forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected ClassicalRungeKuttaFieldStateInterpolator<T> create(Field<T> newField, boolean newForward, T[][] newYDotK, FieldODEStateAndDerivative<T> newGlobalPreviousState, FieldODEStateAndDerivative<T> newGlobalCurrentState, FieldODEStateAndDerivative<T> newSoftPreviousState, FieldODEStateAndDerivative<T> newSoftCurrentState, FieldEquationsMapper<T> newMapper) {
        return new ClassicalRungeKuttaFieldStateInterpolator(newField, newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected FieldODEStateAndDerivative<T> computeInterpolatedStateAndDerivatives(FieldEquationsMapper<T> mapper, T time, T theta, T thetaH, T oneMinusThetaH) {
        CalculusFieldElement[] interpolatedDerivatives;
        CalculusFieldElement[] interpolatedState;
        CalculusFieldElement one = (CalculusFieldElement)time.getField().getOne();
        CalculusFieldElement oneMinusTheta = (CalculusFieldElement)one.subtract(theta);
        CalculusFieldElement oneMinus2Theta = (CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)theta.multiply(2)));
        CalculusFieldElement coeffDot1 = (CalculusFieldElement)oneMinusTheta.multiply((FieldElement)oneMinus2Theta);
        CalculusFieldElement coeffDot23 = (CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)oneMinusTheta)).multiply(2);
        CalculusFieldElement coeffDot4 = (CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)oneMinus2Theta)).negate();
        if (this.getGlobalPreviousState() != null && theta.getReal() <= 0.5) {
            CalculusFieldElement fourTheta2 = (CalculusFieldElement)((CalculusFieldElement)theta.multiply(theta)).multiply(4);
            CalculusFieldElement s = (CalculusFieldElement)thetaH.divide(6.0);
            CalculusFieldElement coeff1 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)fourTheta2.subtract((FieldElement)((CalculusFieldElement)theta.multiply(9)))).add(6.0)));
            CalculusFieldElement coeff23 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply(6)).subtract((FieldElement)fourTheta2)));
            CalculusFieldElement coeff4 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)fourTheta2.subtract((FieldElement)((CalculusFieldElement)theta.multiply(3)))));
            interpolatedState = this.previousStateLinearCombination(new CalculusFieldElement[]{coeff1, coeff23, coeff23, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new CalculusFieldElement[]{coeffDot1, coeffDot23, coeffDot23, coeffDot4});
        } else {
            CalculusFieldElement fourTheta = (CalculusFieldElement)theta.multiply(4);
            CalculusFieldElement s = (CalculusFieldElement)oneMinusThetaH.divide(6.0);
            CalculusFieldElement coeff1 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)fourTheta.negate()).add(5.0)))).subtract(1.0)));
            CalculusFieldElement coeff23 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)fourTheta.subtract(2.0)))).subtract(2.0)));
            CalculusFieldElement coeff4 = (CalculusFieldElement)s.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)theta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)fourTheta.negate()).subtract(1.0)))).subtract(1.0)));
            interpolatedState = this.currentStateLinearCombination(new CalculusFieldElement[]{coeff1, coeff23, coeff23, coeff4});
            interpolatedDerivatives = this.derivativeLinearCombination(new CalculusFieldElement[]{coeffDot1, coeffDot23, coeffDot23, coeffDot4});
        }
        return mapper.mapStateAndDerivative((CalculusFieldElement)time, interpolatedState, interpolatedDerivatives);
    }
}

