/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.util.FastMath;

public class StepsizeHelper {
    private double scalAbsoluteTolerance;
    private double scalRelativeTolerance;
    private double[] vecAbsoluteTolerance;
    private double[] vecRelativeTolerance;
    private int mainSetDimension;
    private double initialStep;
    private double minStep;
    private double maxStep;

    public StepsizeHelper(double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        this.minStep = FastMath.abs((double)minStep);
        this.maxStep = FastMath.abs((double)maxStep);
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = scalAbsoluteTolerance;
        this.scalRelativeTolerance = scalRelativeTolerance;
        this.vecAbsoluteTolerance = null;
        this.vecRelativeTolerance = null;
    }

    public StepsizeHelper(double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        this.minStep = FastMath.abs((double)minStep);
        this.maxStep = FastMath.abs((double)maxStep);
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = 0.0;
        this.scalRelativeTolerance = 0.0;
        this.vecAbsoluteTolerance = (double[])vecAbsoluteTolerance.clone();
        this.vecRelativeTolerance = (double[])vecRelativeTolerance.clone();
    }

    protected void setMainSetDimension(int mainSetDimension) throws MathIllegalArgumentException {
        this.mainSetDimension = mainSetDimension;
        if (this.vecAbsoluteTolerance != null && this.vecAbsoluteTolerance.length != mainSetDimension) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{mainSetDimension, this.vecAbsoluteTolerance.length});
        }
        if (this.vecRelativeTolerance != null && this.vecRelativeTolerance.length != mainSetDimension) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{mainSetDimension, this.vecRelativeTolerance.length});
        }
    }

    public int getMainSetDimension() {
        return this.mainSetDimension;
    }

    public double getRelativeTolerance(int i) {
        return this.vecAbsoluteTolerance == null ? this.scalRelativeTolerance : this.vecRelativeTolerance[i];
    }

    public double getTolerance(int i, double scale) {
        return this.vecAbsoluteTolerance == null ? this.scalAbsoluteTolerance + this.scalRelativeTolerance * scale : this.vecAbsoluteTolerance[i] + this.vecRelativeTolerance[i] * scale;
    }

    public <T extends CalculusFieldElement<T>> T getTolerance(int i, T scale) {
        return (T)(this.vecAbsoluteTolerance == null ? (CalculusFieldElement)((CalculusFieldElement)scale.multiply(this.scalRelativeTolerance)).add(this.scalAbsoluteTolerance) : (CalculusFieldElement)((CalculusFieldElement)scale.multiply(this.vecRelativeTolerance[i])).add(this.vecAbsoluteTolerance[i]));
    }

    public double filterStep(double h, boolean forward, boolean acceptSmall) throws MathIllegalArgumentException {
        double filteredH = h;
        if (FastMath.abs((double)h) < this.minStep) {
            if (acceptSmall) {
                filteredH = forward ? this.minStep : -this.minStep;
            } else {
                throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.MINIMAL_STEPSIZE_REACHED_DURING_INTEGRATION, new Object[]{FastMath.abs((double)h), this.minStep, true});
            }
        }
        if (filteredH > this.maxStep) {
            filteredH = this.maxStep;
        } else if (filteredH < -this.maxStep) {
            filteredH = -this.maxStep;
        }
        return filteredH;
    }

    public <T extends CalculusFieldElement<T>> T filterStep(T h, boolean forward, boolean acceptSmall) throws MathIllegalArgumentException {
        Object filteredH = h;
        if (((CalculusFieldElement)((CalculusFieldElement)h.abs()).subtract(this.minStep)).getReal() < 0.0) {
            if (acceptSmall) {
                filteredH = (CalculusFieldElement)((CalculusFieldElement)h.getField().getZero()).add(forward ? this.minStep : -this.minStep);
            } else {
                throw new MathIllegalArgumentException((Localizable)LocalizedODEFormats.MINIMAL_STEPSIZE_REACHED_DURING_INTEGRATION, new Object[]{FastMath.abs((double)h.getReal()), this.minStep, true});
            }
        }
        if (((CalculusFieldElement)filteredH.subtract(this.maxStep)).getReal() > 0.0) {
            filteredH = (CalculusFieldElement)((CalculusFieldElement)h.getField().getZero()).newInstance(this.maxStep);
        } else if (((CalculusFieldElement)filteredH.add(this.maxStep)).getReal() < 0.0) {
            filteredH = (CalculusFieldElement)((CalculusFieldElement)h.getField().getZero()).newInstance(-this.maxStep);
        }
        return filteredH;
    }

    public void setInitialStepSize(double initialStepSize) {
        this.initialStep = initialStepSize < this.minStep || initialStepSize > this.maxStep ? -1.0 : initialStepSize;
    }

    public double getInitialStep() {
        return this.initialStep;
    }

    public double getMinStep() {
        return this.minStep;
    }

    public double getMaxStep() {
        return this.maxStep;
    }

    public double getDummyStepsize() {
        return FastMath.sqrt((double)(this.minStep * this.maxStep));
    }
}

