/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.util.MathArrays;

public class FieldODEStateAndDerivative<T extends CalculusFieldElement<T>>
extends FieldODEState<T> {
    private final T[] primaryDerivative;
    private final T[][] secondaryDerivative;

    public FieldODEStateAndDerivative(T time, T[] primaryState, T[] primaryDerivative) {
        this((CalculusFieldElement)time, (CalculusFieldElement[])primaryState, (CalculusFieldElement[])primaryDerivative, null, null);
    }

    public FieldODEStateAndDerivative(T time, T[] primaryState, T[] primaryDerivative, T[][] secondaryState, T[][] secondaryDerivative) {
        super(time, primaryState, secondaryState);
        this.primaryDerivative = (CalculusFieldElement[])primaryDerivative.clone();
        this.secondaryDerivative = this.copy((CalculusFieldElement[][])secondaryDerivative);
    }

    public T[] getPrimaryDerivative() {
        return (CalculusFieldElement[])this.primaryDerivative.clone();
    }

    public T[] getSecondaryDerivative(int index) {
        return index == 0 ? (CalculusFieldElement[])this.primaryDerivative.clone() : (CalculusFieldElement[])this.secondaryDerivative[index - 1].clone();
    }

    public T[] getCompleteDerivative() {
        CalculusFieldElement[] completeDerivative = (CalculusFieldElement[])MathArrays.buildArray((Field)this.getTime().getField(), (int)this.getCompleteStateDimension());
        System.arraycopy(this.primaryDerivative, 0, completeDerivative, 0, this.primaryDerivative.length);
        int offset = this.primaryDerivative.length;
        if (this.secondaryDerivative != null) {
            for (T[] ts : this.secondaryDerivative) {
                System.arraycopy(ts, 0, completeDerivative, offset, ts.length);
                offset += ts.length;
            }
        }
        return completeDerivative;
    }
}

