/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.io.Serializable;
import org.hipparchus.complex.Complex;

public class ComplexODEState
implements Serializable {
    private static final long serialVersionUID = 20180902L;
    private final double time;
    private final Complex[] primaryState;
    private final Complex[][] secondaryState;
    private final int completeDimension;

    public ComplexODEState(double time, Complex[] primaryState) {
        this(time, primaryState, null);
    }

    public ComplexODEState(double time, Complex[] primaryState, Complex[][] secondaryState) {
        this.time = time;
        this.primaryState = (Complex[])primaryState.clone();
        this.secondaryState = this.copy(secondaryState);
        int dimension = primaryState.length;
        if (secondaryState != null) {
            for (Complex[] secondary : secondaryState) {
                dimension += secondary.length;
            }
        }
        this.completeDimension = dimension;
    }

    protected Complex[][] copy(Complex[][] original) {
        if (original == null) {
            return null;
        }
        Complex[][] copied = new Complex[original.length][];
        for (int i = 0; i < original.length; ++i) {
            copied[i] = (Complex[])original[i].clone();
        }
        return copied;
    }

    public double getTime() {
        return this.time;
    }

    public int getPrimaryStateDimension() {
        return this.primaryState.length;
    }

    public Complex[] getPrimaryState() {
        return (Complex[])this.primaryState.clone();
    }

    public int getNumberOfSecondaryStates() {
        return this.secondaryState == null ? 0 : this.secondaryState.length;
    }

    public int getSecondaryStateDimension(int index) {
        return index == 0 ? this.primaryState.length : this.secondaryState[index - 1].length;
    }

    public Complex[] getSecondaryState(int index) {
        return index == 0 ? (Complex[])this.primaryState.clone() : (Complex[])this.secondaryState[index - 1].clone();
    }

    public int getCompleteStateDimension() {
        return this.completeDimension;
    }

    public Complex[] getCompleteState() {
        Complex[] completeState = new Complex[this.getCompleteStateDimension()];
        System.arraycopy(this.primaryState, 0, completeState, 0, this.primaryState.length);
        int offset = this.primaryState.length;
        if (this.secondaryState != null) {
            for (Complex[] complexes : this.secondaryState) {
                System.arraycopy(complexes, 0, completeState, offset, complexes.length);
                offset += complexes.length;
            }
        }
        return completeState;
    }
}

