/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.partitioning;

import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.Side;

public interface SubHyperplane<S extends Space, P extends Point<S, P>, H extends Hyperplane<S, P, H, I>, I extends SubHyperplane<S, P, H, I>> {
    public I copySelf();

    public H getHyperplane();

    public boolean isEmpty();

    public double getSize();

    public SplitSubHyperplane<S, P, H, I> split(H var1);

    public I reunite(I var1);

    public P getInteriorPoint();

    public static class SplitSubHyperplane<U extends Space, R extends Point<U, R>, F extends Hyperplane<U, R, F, J>, J extends SubHyperplane<U, R, F, J>> {
        private final J plus;
        private final J minus;

        public SplitSubHyperplane(J plus, J minus) {
            this.plus = plus;
            this.minus = minus;
        }

        public J getPlus() {
            return this.plus;
        }

        public J getMinus() {
            return this.minus;
        }

        public Side getSide() {
            if (this.plus != null && !this.plus.isEmpty()) {
                if (this.minus != null && !this.minus.isEmpty()) {
                    return Side.BOTH;
                }
                return Side.PLUS;
            }
            if (this.minus != null && !this.minus.isEmpty()) {
                return Side.MINUS;
            }
            return Side.HYPER;
        }
    }
}

