/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.partitioning;

import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.BoundaryAttribute;
import org.hipparchus.geometry.partitioning.Characterization;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.NodesSet;
import org.hipparchus.geometry.partitioning.SubHyperplane;

class BoundaryBuilder<S extends Space, P extends Point<S, P>, H extends Hyperplane<S, P, H, I>, I extends SubHyperplane<S, P, H, I>>
implements BSPTreeVisitor<S, P, H, I> {
    BoundaryBuilder() {
    }

    @Override
    public BSPTreeVisitor.Order visitOrder(BSPTree<S, P, H, I> node) {
        return BSPTreeVisitor.Order.PLUS_MINUS_SUB;
    }

    @Override
    public void visitInternalNode(BSPTree<S, P, H, I> node) {
        Characterization<S, P, H, I> minusChar;
        Object plusOutside = null;
        Object plusInside = null;
        NodesSet<S, P, H, I> splitters = null;
        Characterization<S, P, H, I> plusChar = new Characterization<S, P, H, I>(node.getPlus(), node.getCut().copySelf());
        if (plusChar.touchOutside() && (minusChar = new Characterization<S, P, H, I>(node.getMinus(), plusChar.outsideTouching())).touchInside()) {
            plusOutside = minusChar.insideTouching();
            splitters = new NodesSet<S, P, H, I>();
            splitters.addAll(minusChar.getInsideSplitters());
            splitters.addAll(plusChar.getOutsideSplitters());
        }
        if (plusChar.touchInside() && (minusChar = new Characterization<S, P, H, I>(node.getMinus(), plusChar.insideTouching())).touchOutside()) {
            plusInside = minusChar.outsideTouching();
            if (splitters == null) {
                splitters = new NodesSet();
            }
            splitters.addAll(minusChar.getOutsideSplitters());
            splitters.addAll(plusChar.getInsideSplitters());
        }
        if (splitters != null) {
            for (BSPTree<S, P, H, I> up = node.getParent(); up != null; up = up.getParent()) {
                splitters.add(up);
            }
        }
        node.setAttribute(new BoundaryAttribute(plusOutside, plusInside, splitters));
    }

    @Override
    public void visitLeafNode(BSPTree<S, P, H, I> node) {
    }
}

