/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry;

import java.text.NumberFormat;
import org.hipparchus.analysis.polynomials.SmoothStepFactory;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.util.Blendable;

public interface Vector<S extends Space, V extends Vector<S, V>>
extends Point<S, V>,
Blendable<V> {
    public V getZero();

    public double getNorm1();

    public double getNorm();

    public double getNormSq();

    public double getNormInf();

    public V add(V var1);

    public V add(double var1, V var3);

    public V subtract(V var1);

    public V subtract(double var1, V var3);

    public V negate();

    default public V normalize() throws MathRuntimeException {
        double s = this.getNorm();
        if (s == 0.0) {
            throw new MathRuntimeException((Localizable)LocalizedGeometryFormats.CANNOT_NORMALIZE_A_ZERO_NORM_VECTOR, new Object[0]);
        }
        return this.scalarMultiply(1.0 / s);
    }

    public V scalarMultiply(double var1);

    public boolean isInfinite();

    public double distance1(V var1);

    public double distanceInf(V var1);

    public double distanceSq(V var1);

    public double dotProduct(V var1);

    public String toString(NumberFormat var1);

    default public V blendArithmeticallyWith(V other, double blendingValue) throws MathIllegalArgumentException {
        SmoothStepFactory.checkBetweenZeroAndOneIncluded((double)blendingValue);
        return this.scalarMultiply(1.0 - blendingValue).add(other.scalarMultiply(blendingValue));
    }
}

