/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaElementImpl;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexCompositeNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexObjectFieldBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexRootBuilder;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.common.tree.TreeFilterDefinition;
import org.hibernate.search.engine.common.tree.spi.TreeContributionListener;
import org.hibernate.search.engine.common.tree.spi.TreeFilterPathTracker;
import org.hibernate.search.engine.common.tree.spi.TreeNestingContext;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.mapper.mapping.building.impl.IndexedEmbeddedBindingContextImpl;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingMapperContext;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

abstract class AbstractIndexBindingContext<B extends IndexCompositeNodeBuilder>
implements IndexBindingContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final BiFunction<MappingElement, String, SearchException> CYCLIC_RECURSION_EXCEPTION_FACTORY = (mappingElement, cyclicRecursionPath) -> log.indexedEmbeddedCyclicRecursion((MappingElement)mappingElement, mappingElement.eventContext(), (String)cyclicRecursionPath);
    private final IndexedEntityBindingMapperContext mapperContext;
    private final IndexRootBuilder indexRootBuilder;
    final B indexSchemaObjectNodeBuilder;
    final TreeNestingContext nestingContext;

    AbstractIndexBindingContext(IndexedEntityBindingMapperContext mapperContext, IndexRootBuilder indexRootBuilder, B indexSchemaObjectNodeBuilder, TreeNestingContext nestingContext) {
        this.mapperContext = mapperContext;
        this.indexRootBuilder = indexRootBuilder;
        this.indexSchemaObjectNodeBuilder = indexSchemaObjectNodeBuilder;
        this.nestingContext = nestingContext;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexSchemaObjectNodeBuilder=" + this.indexSchemaObjectNodeBuilder + ",nestingContext=" + this.nestingContext + "]";
    }

    @Override
    public IndexFieldTypeFactory createTypeFactory(IndexFieldTypeDefaultsProvider defaultsProvider) {
        return this.indexRootBuilder.createTypeFactory(defaultsProvider);
    }

    @Override
    public IndexSchemaElement schemaElement() {
        return new IndexSchemaElementImpl<B>(this.createTypeFactory(), this.indexSchemaObjectNodeBuilder, this.nestingContext, this.isParentMultivaluedAndWithoutObjectField());
    }

    @Override
    public IndexSchemaElement schemaElement(TreeContributionListener listener) {
        return new IndexSchemaElementImpl<B>(this.createTypeFactory(), this.indexSchemaObjectNodeBuilder, TreeNestingContext.notifying(this.nestingContext, listener), this.isParentMultivaluedAndWithoutObjectField());
    }

    @Override
    public Optional<IndexedEmbeddedBindingContext> addIndexedEmbeddedIfIncluded(MappingElement mappingElement, String relativePrefix, ObjectStructure structure, TreeFilterDefinition filter, boolean multiValued) {
        TreeFilterPathTracker pathTracker = this.mapperContext.getOrCreatePathTracker(mappingElement, filter);
        return this.nestingContext.nestComposed(mappingElement, relativePrefix, filter, pathTracker, new NestedContextBuilderImpl(this.mapperContext, this.indexRootBuilder, (IndexCompositeNodeBuilder)this.indexSchemaObjectNodeBuilder, structure, this.isParentMultivaluedAndWithoutObjectField() || multiValued), CYCLIC_RECURSION_EXCEPTION_FACTORY);
    }

    abstract boolean isParentMultivaluedAndWithoutObjectField();

    private static class NestedContextBuilderImpl
    implements TreeNestingContext.NestedContextBuilder<IndexedEmbeddedBindingContext> {
        private final IndexedEntityBindingMapperContext mapperContext;
        private final IndexRootBuilder indexRootBuilder;
        private IndexCompositeNodeBuilder currentNodeBuilder;
        private final ObjectStructure structure;
        private final List<IndexObjectFieldReference> parentIndexObjectReferences = new ArrayList<IndexObjectFieldReference>();
        private boolean multiValued;

        private NestedContextBuilderImpl(IndexedEntityBindingMapperContext mapperContext, IndexRootBuilder indexRootBuilder, IndexCompositeNodeBuilder currentNodeBuilder, ObjectStructure structure, boolean multiValued) {
            this.mapperContext = mapperContext;
            this.indexRootBuilder = indexRootBuilder;
            this.currentNodeBuilder = currentNodeBuilder;
            this.structure = structure;
            this.multiValued = multiValued;
        }

        @Override
        public void appendObject(String objectName) {
            IndexObjectFieldBuilder nextNodeBuilder = this.currentNodeBuilder.addObjectField(objectName, TreeNodeInclusion.INCLUDED, this.structure);
            if (this.multiValued) {
                this.multiValued = false;
                nextNodeBuilder.multiValued();
            }
            this.parentIndexObjectReferences.add(nextNodeBuilder.toReference());
            this.currentNodeBuilder = nextNodeBuilder;
        }

        @Override
        public IndexedEmbeddedBindingContext build(TreeNestingContext nestingContext) {
            return new IndexedEmbeddedBindingContextImpl(this.mapperContext, this.indexRootBuilder, this.currentNodeBuilder, this.parentIndexObjectReferences, nestingContext, this.multiValued);
        }
    }
}

