/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.model.spi;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.hibernate.search.engine.backend.document.model.spi.AbstractIndexFieldTemplate;
import org.hibernate.search.engine.backend.document.model.spi.IndexCompositeNode;
import org.hibernate.search.engine.backend.document.model.spi.IndexField;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.document.model.spi.IndexIdentifier;
import org.hibernate.search.engine.backend.metamodel.IndexDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexFieldDescriptor;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public abstract class AbstractIndexModel<S extends AbstractIndexModel<?, R, F>, R extends IndexCompositeNode<?, ?, ?>, F extends IndexField<?, ?>>
implements EventContextProvider,
IndexDescriptor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String hibernateSearchIndexName;
    private final EventContext eventContext;
    private final String mappedTypeName;
    private final IndexIdentifier identifier;
    private final R root;
    private final Map<String, F> staticFields;
    private final List<IndexFieldDescriptor> includedStaticFields;
    private final List<? extends AbstractIndexFieldTemplate<? super S, ? extends F, ? super R, ?>> fieldTemplates;
    private final ConcurrentMap<String, F> dynamicFieldsCache = new ConcurrentHashMap<String, F>();

    public AbstractIndexModel(String hibernateSearchIndexName, String mappedTypeName, IndexIdentifier identifier, R root, Map<String, F> staticFields, List<? extends AbstractIndexFieldTemplate<? super S, ? extends F, ? super R, ?>> fieldTemplates) {
        this.hibernateSearchIndexName = hibernateSearchIndexName;
        this.eventContext = EventContexts.fromIndexName(hibernateSearchIndexName);
        this.mappedTypeName = mappedTypeName;
        this.identifier = identifier;
        this.root = root;
        this.staticFields = CollectionHelper.toImmutableMap(staticFields);
        this.includedStaticFields = CollectionHelper.toImmutableList(staticFields.values().stream().filter(field -> TreeNodeInclusion.INCLUDED.equals((Object)field.inclusion())).collect(Collectors.toList()));
        this.fieldTemplates = fieldTemplates;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[indexName=" + this.hibernateSearchIndexName + "]";
    }

    protected abstract S self();

    public final EventContext eventContext() {
        return this.eventContext;
    }

    @Override
    public final String hibernateSearchName() {
        return this.hibernateSearchIndexName;
    }

    public IndexIdentifier identifier() {
        return this.identifier;
    }

    public final R root() {
        return this.root;
    }

    @Override
    public final Optional<IndexFieldDescriptor> field(String absolutePath) {
        return Optional.ofNullable(this.fieldOrNull(absolutePath));
    }

    public final F fieldOrNull(String absolutePath) {
        return this.fieldOrNull(absolutePath, IndexFieldFilter.INCLUDED_ONLY);
    }

    public final F fieldOrNull(String absolutePath, IndexFieldFilter filter) {
        try {
            F field = this.fieldOrNullIgnoringInclusion(absolutePath);
            return (F)(field == null ? null : (IndexField)filter.filter(field, field.inclusion()));
        }
        catch (SearchException e) {
            throw log.unableToResolveField(absolutePath, e.getMessage(), e, this.eventContext);
        }
    }

    @Override
    public final Collection<IndexFieldDescriptor> staticFields() {
        return this.includedStaticFields;
    }

    public final String mappedTypeName() {
        return this.mappedTypeName;
    }

    private F fieldOrNullIgnoringInclusion(String absolutePath) {
        IndexField field = (IndexField)this.staticFields.get(absolutePath);
        if (field != null) {
            return (F)field;
        }
        field = (IndexField)this.dynamicFieldsCache.get(absolutePath);
        if (field != null) {
            return (F)field;
        }
        for (AbstractIndexFieldTemplate<S, F, R, ?> template : this.fieldTemplates) {
            field = template.createNodeIfMatching(this.self(), this.root, absolutePath);
            if (field == null) continue;
            IndexField previous = this.dynamicFieldsCache.putIfAbsent(absolutePath, field);
            if (previous == null) break;
            field = previous;
            break;
        }
        return (F)field;
    }
}

