/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.aws.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.aws.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.aws.spi.ElasticsearchAwsCredentialsProvider;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

public class ElasticsearchAwsStaticCredentialsProvider
implements ElasticsearchAwsCredentialsProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    static final OptionalConfigurationProperty<String> CREDENTIALS_ACCESS_KEY_ID = ConfigurationProperty.forKey((String)"aws.credentials.access_key_id").asString().build();
    static final OptionalConfigurationProperty<String> CREDENTIALS_SECRET_ACCESS_KEY = ConfigurationProperty.forKey((String)"aws.credentials.secret_access_key").asString().build();

    @Override
    public AwsCredentialsProvider create(ConfigurationPropertySource propertySource) {
        String accessKey = (String)CREDENTIALS_ACCESS_KEY_ID.getOrThrow(propertySource, () -> log.missingPropertyForSigningWithCredentialsType("static"));
        String secretKey = (String)CREDENTIALS_SECRET_ACCESS_KEY.getOrThrow(propertySource, () -> log.missingPropertyForSigningWithCredentialsType("static"));
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey));
    }
}

