
package org.hibernate.processor.xml.jaxb;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 *         @Target({TYPE}) @Retention(RUNTIME)
 *         public @interface NamedEntityGraph {
 *           String name() default "";
 *           NamedAttributeNode[] attributeNodes() default {};
 *           boolean includeAllAttributes() default false;
 *           NamedSubgraph[] subgraphs() default {};
 *           NamedSubGraph[] subclassSubgraphs() default {};
 *         }
 * 
 *       
 * 
 * <p>Java class for named-entity-graph complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="named-entity-graph">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="named-attribute-node" type="{https://jakarta.ee/xml/ns/persistence/orm}named-attribute-node" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="subgraph" type="{https://jakarta.ee/xml/ns/persistence/orm}named-subgraph" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="subclass-subgraph" type="{https://jakarta.ee/xml/ns/persistence/orm}named-subgraph" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="include-all-attributes" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "named-entity-graph", namespace = "https://jakarta.ee/xml/ns/persistence/orm", propOrder = {
    "namedAttributeNode",
    "subgraph",
    "subclassSubgraph"
})
public class NamedEntityGraph {

    @XmlElement(name = "named-attribute-node", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<NamedAttributeNode> namedAttributeNode;
    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<NamedSubgraph> subgraph;
    @XmlElement(name = "subclass-subgraph", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected List<NamedSubgraph> subclassSubgraph;
    @XmlAttribute(name = "name")
    protected String name;
    @XmlAttribute(name = "include-all-attributes")
    protected Boolean includeAllAttributes;

    /**
     * Gets the value of the namedAttributeNode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the namedAttributeNode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNamedAttributeNode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NamedAttributeNode }
     * 
     * 
     * @return
     *     The value of the namedAttributeNode property.
     */
    public List<NamedAttributeNode> getNamedAttributeNode() {
        if (namedAttributeNode == null) {
            namedAttributeNode = new ArrayList<>();
        }
        return this.namedAttributeNode;
    }

    /**
     * Gets the value of the subgraph property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the subgraph property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSubgraph().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NamedSubgraph }
     * 
     * 
     * @return
     *     The value of the subgraph property.
     */
    public List<NamedSubgraph> getSubgraph() {
        if (subgraph == null) {
            subgraph = new ArrayList<>();
        }
        return this.subgraph;
    }

    /**
     * Gets the value of the subclassSubgraph property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the subclassSubgraph property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSubclassSubgraph().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NamedSubgraph }
     * 
     * 
     * @return
     *     The value of the subclassSubgraph property.
     */
    public List<NamedSubgraph> getSubclassSubgraph() {
        if (subclassSubgraph == null) {
            subclassSubgraph = new ArrayList<>();
        }
        return this.subclassSubgraph;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the includeAllAttributes property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isIncludeAllAttributes() {
        return includeAllAttributes;
    }

    /**
     * Sets the value of the includeAllAttributes property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIncludeAllAttributes(Boolean value) {
        this.includeAllAttributes = value;
    }

}
