/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.util;

import java.util.Locale;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class StringUtil {
    private static final @UnknownKeyFor @NonNull @Initialized String NAME_SEPARATOR = ".";
    private static final @UnknownKeyFor @NonNull @Initialized String PROPERTY_PREFIX_GET = "get";
    private static final @UnknownKeyFor @NonNull @Initialized String PROPERTY_PREFIX_IS = "is";
    private static final @UnknownKeyFor @NonNull @Initialized String PROPERTY_PREFIX_HAS = "has";

    private StringUtil() {
    }

    public static @UnknownKeyFor @NonNull @Initialized String determineFullyQualifiedClassName(@UnknownKeyFor @NonNull @Initialized String defaultPackage, @UnknownKeyFor @NonNull @Initialized String name) {
        if (StringUtil.isFullyQualified(name)) {
            return name;
        }
        return defaultPackage + NAME_SEPARATOR + name;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isFullyQualified(@UnknownKeyFor @NonNull @Initialized String name) {
        return name.contains(NAME_SEPARATOR);
    }

    public static @UnknownKeyFor @NonNull @Initialized String packageNameFromFqcn(@UnknownKeyFor @NonNull @Initialized String fqcn) {
        return fqcn.substring(0, fqcn.lastIndexOf(NAME_SEPARATOR));
    }

    public static @UnknownKeyFor @NonNull @Initialized String classNameFromFqcn(@UnknownKeyFor @NonNull @Initialized String fqcn) {
        return fqcn.substring(fqcn.lastIndexOf(NAME_SEPARATOR) + 1);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isProperty(@UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String returnTypeAsString) {
        if (methodName == null || "void".equals(returnTypeAsString)) {
            return false;
        }
        if (StringUtil.isValidPropertyName(methodName, PROPERTY_PREFIX_GET)) {
            return true;
        }
        if (StringUtil.isValidPropertyName(methodName, PROPERTY_PREFIX_IS) || StringUtil.isValidPropertyName(methodName, PROPERTY_PREFIX_HAS)) {
            return StringUtil.isBooleanGetter(returnTypeAsString);
        }
        return false;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isBooleanGetter(@UnknownKeyFor @NonNull @Initialized String type) {
        return "Boolean".equals(type) || "java.lang.Boolean".equals(type);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isValidPropertyName(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String prefix) {
        if (!name.startsWith(prefix)) {
            return false;
        }
        return name.length() >= prefix.length() + 1;
    }

    public static @UnknownKeyFor @NonNull @Initialized String getPropertyName(@UnknownKeyFor @NonNull @Initialized String name) {
        String tmp = name;
        if (name.startsWith(PROPERTY_PREFIX_GET)) {
            tmp = name.replaceFirst(PROPERTY_PREFIX_GET, "");
        } else if (name.startsWith(PROPERTY_PREFIX_IS)) {
            tmp = name.replaceFirst(PROPERTY_PREFIX_IS, "");
        } else if (name.startsWith(PROPERTY_PREFIX_HAS)) {
            tmp = name.replaceFirst(PROPERTY_PREFIX_HAS, "");
        }
        return StringUtil.decapitalize(tmp);
    }

    public static @UnknownKeyFor @NonNull @Initialized String decapitalize(@UnknownKeyFor @NonNull @Initialized String string) {
        if (string == null || string.isEmpty() || StringUtil.startsWithSeveralUpperCaseLetters(string)) {
            return string;
        }
        return string.substring(0, 1).toLowerCase(Locale.ROOT) + string.substring(1);
    }

    public static @UnknownKeyFor @NonNull @Initialized String nameToFieldName(@UnknownKeyFor @NonNull @Initialized String name) {
        return StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(StringUtil.nameToMethodName(name));
    }

    public static @UnknownKeyFor @NonNull @Initialized String nameToMethodName(@UnknownKeyFor @NonNull @Initialized String name) {
        return name.replaceAll("[\\s.\\-!@#%=+/*^&|(){}\\[\\]]", "_");
    }

    public static @UnknownKeyFor @NonNull @Initialized String getUpperUnderscoreCaseFromLowerCamelCase(@UnknownKeyFor @NonNull @Initialized String lowerCamelCaseString) {
        return lowerCamelCaseString.replaceAll("(.)(\\p{Upper})", "$1_$2").toUpperCase(Locale.ROOT);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean startsWithSeveralUpperCaseLetters(@UnknownKeyFor @NonNull @Initialized String string) {
        return string.length() > 1 && Character.isUpperCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1));
    }
}

