/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.id;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.id.AbstractCompositeIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.AbstractIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.internal.entities.mapper.id.SimpleIdMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.id.SingleIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.VirtualEntitySingleIdMapper;
import org.hibernate.mapping.Component;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.spi.CompositeTypeImplementor;

public class MultipleIdMapper
extends AbstractCompositeIdMapper
implements SimpleIdMapperBuilder {
    public MultipleIdMapper(Component component) {
        super(component);
    }

    private MultipleIdMapper(CompositeTypeImplementor compositeType, ServiceRegistry serviceRegistry) {
        super(serviceRegistry, compositeType);
    }

    @Override
    public void add(PropertyData propertyData) {
        this.ids.put(propertyData, this.resolveIdMapper(propertyData));
    }

    @Override
    public void mapToMapFromId(Session session, Map<String, Object> data, Object obj) {
        if (this.compositeType.getReturnedClass().isInstance(obj)) {
            LazyInitializer lazyInitializer;
            if (this.compositeType.isEmbedded() && (lazyInitializer = HibernateProxy.extractLazyInitializer((Object)obj)) != null) {
                obj = lazyInitializer.getInternalIdentifier();
            }
            for (Map.Entry entry : this.ids.entrySet()) {
                PropertyData propertyData = (PropertyData)entry.getKey();
                AbstractIdMapper idMapper = (AbstractIdMapper)entry.getValue();
                if (propertyData.getVirtualReturnClass() == null) {
                    idMapper.mapToMapFromEntity(data, obj);
                    continue;
                }
                idMapper.mapToMapFromId(session, data, obj);
            }
        } else {
            this.mapToMapFromId(data, obj);
        }
    }

    @Override
    public void mapToMapFromId(Map<String, Object> data, Object obj) {
        for (IdMapper idMapper : this.ids.values()) {
            idMapper.mapToMapFromEntity(data, obj);
        }
    }

    @Override
    public void mapToMapFromEntity(Map<String, Object> data, Object obj) {
        LazyInitializer lazyInitializer;
        if (this.compositeType.isEmbedded() && (lazyInitializer = HibernateProxy.extractLazyInitializer((Object)obj)) != null) {
            obj = lazyInitializer.getInternalIdentifier();
        }
        for (IdMapper idMapper : this.ids.values()) {
            idMapper.mapToMapFromEntity(data, obj);
        }
    }

    @Override
    public boolean mapToEntityFromMap(Object obj, Map data) {
        boolean ret = true;
        for (IdMapper idMapper : this.ids.values()) {
            ret &= idMapper.mapToEntityFromMap(obj, data);
        }
        return ret;
    }

    @Override
    public IdMapper prefixMappedProperties(String prefix) {
        MultipleIdMapper ret = new MultipleIdMapper(this.compositeType, this.getServiceRegistry());
        for (PropertyData propertyData : this.ids.keySet()) {
            String propertyName = propertyData.getName();
            ret.ids.put(propertyData, this.resolveIdMapper(new PropertyData(prefix + propertyName, propertyData)));
        }
        return ret;
    }

    @Override
    public Object mapToIdFromEntity(Object data) {
        if (data == null) {
            return null;
        }
        Object compositeId = this.instantiateCompositeId(null);
        for (AbstractIdMapper mapper : this.ids.values()) {
            mapper.mapToEntityFromEntity(compositeId, data);
        }
        return compositeId;
    }

    @Override
    public List<QueryParameterData> mapToQueryParametersFromId(Object obj) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        this.mapToMapFromId(data, obj);
        ArrayList<QueryParameterData> ret = new ArrayList<QueryParameterData>();
        for (Map.Entry propertyData : data.entrySet()) {
            ret.add(new QueryParameterData((String)propertyData.getKey(), propertyData.getValue()));
        }
        return ret;
    }

    private SingleIdMapper resolveIdMapper(PropertyData propertyData) {
        if (propertyData.getVirtualReturnClass() != null) {
            return new VirtualEntitySingleIdMapper(this.getServiceRegistry(), propertyData);
        }
        return new SingleIdMapper(this.getServiceRegistry(), propertyData);
    }
}

