/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.Locale;
import java.util.Map;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.boot.model.AttributeContainer;
import org.hibernate.envers.boot.model.BasicAttribute;
import org.hibernate.envers.boot.model.Identifier;
import org.hibernate.envers.boot.model.JoinedSubclassPersistentEntity;
import org.hibernate.envers.boot.model.PersistentEntity;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.configuration.internal.metadata.AuditEntityConfigurationRegistry;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.IdMappingData;
import org.hibernate.envers.internal.entities.RevisionTypeType;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.strategy.spi.MappingContext;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;

public abstract class AbstractMetadataGenerator {
    private final EnversMetadataBuildingContext metadataBuildingContext;
    private final AuditEntityConfigurationRegistry entityConfigurationRegistry;

    public AbstractMetadataGenerator(EnversMetadataBuildingContext metadataBuildingContext) {
        this.metadataBuildingContext = metadataBuildingContext;
        this.entityConfigurationRegistry = metadataBuildingContext.getAuditEntityConfigurationRegistry();
    }

    protected EnversMetadataBuildingContext getMetadataBuildingContext() {
        return this.metadataBuildingContext;
    }

    public Map<String, EntityConfiguration> getAuditedEntityConfigurations() {
        return this.entityConfigurationRegistry.getAuditedEntityConfigurations();
    }

    public Map<String, EntityConfiguration> getNotAuditedEntityConfigurations() {
        return this.entityConfigurationRegistry.getNotAuditedEntityConfigurations();
    }

    protected boolean hasAuditedEntityConfiguration(String entityName) {
        return this.entityConfigurationRegistry.hasAuditedEntityConfiguration(entityName);
    }

    protected boolean hasNotAuditedEntityConfiguration(String entityName) {
        return this.entityConfigurationRegistry.hasNotAuditedEntityConfiguration(entityName);
    }

    protected EntityConfiguration getAuditedEntityConfiguration(String entityName) {
        return this.entityConfigurationRegistry.getAuditedEntityConfiguration(entityName);
    }

    protected EntityConfiguration getNotAuditedEntityConfiguration(String entityName) {
        return this.entityConfigurationRegistry.getNotAuditedEntityConfiguration(entityName);
    }

    protected void addAuditedEntityConfiguration(String entityName, EntityConfiguration entityConfiguration) {
        this.entityConfigurationRegistry.addAuditedEntityConfiguration(entityName, entityConfiguration);
    }

    protected void addNotAuditedEntityConfiguration(String entityName, EntityConfiguration entityConfiguration) {
        this.entityConfigurationRegistry.addNotAuditedEntityConfiguration(entityName, entityConfiguration);
    }

    protected String getSchemaName(String schemaFromAnnotation, Table table) {
        String schemaName = schemaFromAnnotation;
        if (StringTools.isEmpty(schemaName) && StringTools.isEmpty(schemaName = this.metadataBuildingContext.getConfiguration().getDefaultSchemaName())) {
            schemaName = table.getSchema();
        }
        return schemaName;
    }

    protected String getCatalogName(String catalogFromAnnotation, Table table) {
        String catalogName = catalogFromAnnotation;
        if (StringTools.isEmpty(catalogName) && StringTools.isEmpty(catalogName = this.metadataBuildingContext.getConfiguration().getDefaultCatalogName())) {
            catalogName = table.getCatalog();
        }
        return catalogName;
    }

    protected void addRevisionInfoRelationToIdentifier(Identifier identifier) {
        Configuration configuration = this.metadataBuildingContext.getConfiguration();
        identifier.addAttribute(configuration.getRevisionInfo().getRevisionInfoRelationMapping());
    }

    protected void addAuditStrategyAdditionalColumnsToEntity(PersistentEntity entity) {
        this.metadataBuildingContext.getConfiguration().getAuditStrategy().addAdditionalColumns(new MappingContext(entity, this.metadataBuildingContext.getConfiguration(), this.metadataBuildingContext.getConfiguration().getRevisionTypePropertyType(), this.metadataBuildingContext.getConfiguration().getRevisionInfo().getRevisionInfoClass().getName(), false));
    }

    protected void addAuditStrategyRevisionEndTimestampOnly(PersistentEntity entity) {
        if (entity instanceof JoinedSubclassPersistentEntity) {
            this.metadataBuildingContext.getConfiguration().getAuditStrategy().addAdditionalColumns(new MappingContext(entity, this.metadataBuildingContext.getConfiguration(), this.metadataBuildingContext.getConfiguration().getRevisionTypePropertyType(), this.metadataBuildingContext.getConfiguration().getRevisionInfo().getRevisionInfoClass().getName(), true));
        }
    }

    protected void addRevisionTypeToAttributeContainer(AttributeContainer container, boolean key) {
        container.addAttribute(new BasicAttribute(this.metadataBuildingContext.getConfiguration().getRevisionTypePropertyName(), this.metadataBuildingContext.getConfiguration().getRevisionTypePropertyType(), true, key, RevisionTypeType.class.getName()));
    }

    protected IdMappingData getReferencedIdMappingData(String entityName, String referencedEntityName, PropertyAuditingData propertyAuditingData, boolean allowNotAuditedTarget) {
        EntityConfiguration configuration = this.getAuditedEntityConfiguration(referencedEntityName);
        if (!(configuration != null || (configuration = this.getNotAuditedEntityConfiguration(referencedEntityName)) != null && allowNotAuditedTarget && this.isRelationNotAudited(propertyAuditingData))) {
            throw new EnversMappingException(String.format("An audited relation from %s.%s to a not audited entity %s! %s", entityName, propertyAuditingData.getName(), referencedEntityName, allowNotAuditedTarget ? "Such a mapping is possible but requires using @Audited(targetAuditMode = NOT_AUDITED)." : ""));
        }
        return configuration.getIdMappingData();
    }

    protected void throwUnsupportedTypeException(Type type, String entityName, String propertyName) {
        throw new EnversMappingException(String.format(Locale.ENGLISH, "Type not supported for auditing: %s, on entity %s, property '%s'.", type.getClass().getName(), entityName, propertyName));
    }

    private boolean isRelationNotAudited(PropertyAuditingData propertyAuditingData) {
        return RelationTargetAuditMode.NOT_AUDITED.equals((Object)propertyAuditingData.getRelationTargetAuditMode());
    }
}

