/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities;

import java.util.Objects;
import org.hibernate.envers.internal.entities.PropertyData;

public class RevisionTimestampData
extends PropertyData {
    private final String typeName;

    public RevisionTimestampData(String name, String beanName, String accessType, String typeName) {
        super(name, beanName, accessType);
        this.typeName = typeName;
    }

    public RevisionTimestampData(RevisionTimestampData old, String typeName) {
        this(old.getName(), old.getBeanName(), old.getAccessType(), typeName);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isTimestampDate() {
        return "date".equals(this.typeName) || "time".equals(this.typeName) || "timestamp".equals(this.typeName);
    }

    public boolean isTimestampLocalDateTime() {
        return "LocalDateTime".equals(this.typeName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RevisionTimestampData that = (RevisionTimestampData)o;
        return Objects.equals(this.typeName, that.typeName);
    }
}

