/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.strategy.DefaultAuditStrategy;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class AuditEntitiesConfiguration {
    private final String auditTablePrefix;
    private final String auditTableSuffix;
    private final String auditStrategyName;
    private final String originalIdPropName;
    private final String revisionFieldName;
    private final String revisionNumberPath;
    private final String revisionPropBasePath;
    private final String revisionTypePropName;
    private final String revisionTypePropType;
    private final String revisionInfoEntityName;
    private final Map<String, String> customAuditTablesNames;
    private final String revisionEndFieldName;
    private final boolean revisionEndTimestampEnabled;
    private final String revisionEndTimestampFieldName;
    private final String embeddableSetOrdinalPropertyName;
    private final EnversService enversService;

    public AuditEntitiesConfiguration(Properties properties, String revisionInfoEntityName, EnversService enversService) {
        this.revisionInfoEntityName = revisionInfoEntityName;
        this.enversService = enversService;
        this.auditTablePrefix = ConfigurationHelper.getString((String)"org.hibernate.envers.audit_table_prefix", (Map)properties, (String)"");
        this.auditTableSuffix = ConfigurationHelper.getString((String)"org.hibernate.envers.audit_table_suffix", (Map)properties, (String)"_AUD");
        this.auditStrategyName = ConfigurationHelper.getString((String)"org.hibernate.envers.audit_strategy", (Map)properties, (String)DefaultAuditStrategy.class.getName());
        this.originalIdPropName = ConfigurationHelper.getString((String)"org.hibernate.envers.original_id_prop_name", (Map)properties, (String)"originalId");
        this.revisionFieldName = ConfigurationHelper.getString((String)"org.hibernate.envers.revision_field_name", (Map)properties, (String)"REV");
        this.revisionTypePropName = ConfigurationHelper.getString((String)"org.hibernate.envers.revision_type_field_name", (Map)properties, (String)"REVTYPE");
        this.revisionTypePropType = "byte";
        this.revisionEndFieldName = ConfigurationHelper.getString((String)"org.hibernate.envers.audit_strategy_validity_end_rev_field_name", (Map)properties, (String)"REVEND");
        this.revisionEndTimestampEnabled = ConfigurationHelper.getBoolean((String)"org.hibernate.envers.audit_strategy_validity_store_revend_timestamp", (Map)properties, (boolean)false);
        this.revisionEndTimestampFieldName = this.revisionEndTimestampEnabled ? ConfigurationHelper.getString((String)"org.hibernate.envers.audit_strategy_validity_revend_timestamp_field_name", (Map)properties, (String)"REVEND_TSTMP") : null;
        this.customAuditTablesNames = new HashMap<String, String>();
        this.revisionNumberPath = this.originalIdPropName + "." + this.revisionFieldName + ".id";
        this.revisionPropBasePath = this.originalIdPropName + "." + this.revisionFieldName + ".";
        this.embeddableSetOrdinalPropertyName = ConfigurationHelper.getString((String)"org.hibernate.envers.embeddable_set_ordinal_field_name", (Map)properties, (String)"SETORDINAL");
    }

    public String getOriginalIdPropName() {
        return this.originalIdPropName;
    }

    public String getRevisionFieldName() {
        return this.revisionFieldName;
    }

    public boolean isRevisionEndTimestampEnabled() {
        return this.revisionEndTimestampEnabled;
    }

    public String getRevisionEndTimestampFieldName() {
        return this.revisionEndTimestampFieldName;
    }

    public String getRevisionNumberPath() {
        return this.revisionNumberPath;
    }

    public String getRevisionPropPath(String propertyName) {
        return this.revisionPropBasePath + propertyName;
    }

    public String getRevisionTypePropName() {
        return this.revisionTypePropName;
    }

    public String getRevisionTypePropType() {
        return this.revisionTypePropType;
    }

    public String getRevisionInfoEntityName() {
        return this.revisionInfoEntityName;
    }

    public void addCustomAuditTableName(String entityName, String tableName) {
        this.customAuditTablesNames.put(entityName, tableName);
    }

    public String getAuditEntityName(String entityName) {
        return this.auditTablePrefix + entityName + this.auditTableSuffix;
    }

    public String getAuditTableName(String entityName, String tableName) {
        String customHistoryTableName = this.customAuditTablesNames.get(entityName);
        if (customHistoryTableName == null) {
            return this.auditTablePrefix + tableName + this.auditTableSuffix;
        }
        return customHistoryTableName;
    }

    public String getAuditStrategyName() {
        return this.auditStrategyName;
    }

    public String getRevisionEndFieldName() {
        return this.revisionEndFieldName;
    }

    public String getEmbeddableSetOrdinalPropertyName() {
        return this.embeddableSetOrdinalPropertyName;
    }

    @Deprecated
    public EnversService getEnversService() {
        return this.enversService;
    }
}

