/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Locale;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.HdrHistogram.AbstractHistogramBase;
import org.HdrHistogram.AllValuesIterator;
import org.HdrHistogram.HistogramData;
import org.HdrHistogram.HistogramIterationValue;
import org.HdrHistogram.LinearIterator;
import org.HdrHistogram.LogarithmicIterator;
import org.HdrHistogram.PercentileIterator;
import org.HdrHistogram.RecordedValuesIterator;

public abstract class AbstractHistogram
extends AbstractHistogramBase
implements Serializable {
    int subBucketHalfCountMagnitude;
    int unitMagnitude;
    int subBucketHalfCount;
    long subBucketMask;
    private static final long serialVersionUID = 42L;
    private static final int encodingCookieBase = 478450440;
    private static final int compressedEncodingCookieBase = 478450441;
    private static final Class[] constructorArgsTypes = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE};

    abstract long getCountAtIndex(int var1);

    abstract void incrementCountAtIndex(int var1);

    abstract void addToCountAtIndex(int var1, long var2);

    public abstract long getTotalCount();

    abstract void setTotalCount(long var1);

    abstract void incrementTotalCount();

    abstract void addToTotalCount(long var1);

    abstract void clearCounts();

    abstract int _getEstimatedFootprintInBytes();

    public AbstractHistogram(long lowestTrackableValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        if (lowestTrackableValue < 1L) {
            throw new IllegalArgumentException("lowestTrackableValue must be >= 1");
        }
        if (highestTrackableValue < 2L * lowestTrackableValue) {
            throw new IllegalArgumentException("highestTrackableValue must be >= 2 * lowestTrackableValue");
        }
        if (numberOfSignificantValueDigits < 0 || numberOfSignificantValueDigits > 5) {
            throw new IllegalArgumentException("numberOfSignificantValueDigits must be between 0 and 6");
        }
        this.identity = constructionIdentityCount.getAndIncrement();
        this.init(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits, 0L);
    }

    AbstractHistogram(AbstractHistogram source) {
        this(source.getLowestTrackableValue(), source.getHighestTrackableValue(), source.getNumberOfSignificantValueDigits());
        this.setStartTimeStamp(source.getStartTimeStamp());
        this.setEndTimeStamp(source.getEndTimeStamp());
    }

    private void init(long lowestTrackableValue, long highestTrackableValue, int numberOfSignificantValueDigits, long totalCount) {
        this.highestTrackableValue = highestTrackableValue;
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        this.lowestTrackableValue = lowestTrackableValue;
        long largestValueWithSingleUnitResolution = 2L * (long)Math.pow(10.0, numberOfSignificantValueDigits);
        this.unitMagnitude = (int)Math.floor(Math.log(lowestTrackableValue) / Math.log(2.0));
        int subBucketCountMagnitude = (int)Math.ceil(Math.log(largestValueWithSingleUnitResolution) / Math.log(2.0));
        this.subBucketHalfCountMagnitude = (subBucketCountMagnitude > 1 ? subBucketCountMagnitude : 1) - 1;
        this.subBucketCount = (int)Math.pow(2.0, this.subBucketHalfCountMagnitude + 1);
        this.subBucketHalfCount = this.subBucketCount / 2;
        this.subBucketMask = this.subBucketCount - 1 << this.unitMagnitude;
        this.bucketCount = this.getBucketsNeededToCoverValue(highestTrackableValue);
        this.countsArrayLength = this.getLengthForNumberOfBuckets(this.bucketCount);
        this.setTotalCount(totalCount);
        this.histogramData = new HistogramData(this);
        this.percentileIterator = new PercentileIterator(this, 1);
        this.recordedValuesIterator = new RecordedValuesIterator(this);
    }

    public void recordValue(long value) throws ArrayIndexOutOfBoundsException {
        this.recordSingleValue(value);
    }

    public void recordValueWithCount(long value, long count) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(count, value);
    }

    public void recordValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordValueWithCountAndExpectedInterval(value, 1L, expectedIntervalBetweenValueSamples);
    }

    public void recordValue(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
    }

    private void recordCountAtValue(long count, long value) throws ArrayIndexOutOfBoundsException {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        int countsIndex = this.countsArrayIndex(bucketIndex, subBucketIndex);
        this.addToCountAtIndex(countsIndex, count);
        this.addToTotalCount(count);
    }

    private void recordSingleValue(long value) throws ArrayIndexOutOfBoundsException {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        int countsIndex = this.countsArrayIndex(bucketIndex, subBucketIndex);
        this.incrementCountAtIndex(countsIndex);
        this.incrementTotalCount();
    }

    private void recordValueWithCountAndExpectedInterval(long value, long count, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(count, value);
        if (expectedIntervalBetweenValueSamples <= 0L) {
            return;
        }
        for (long missingValue = value - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
            this.recordCountAtValue(count, missingValue);
        }
    }

    public void reset() {
        this.clearCounts();
    }

    public abstract AbstractHistogram copy();

    public abstract AbstractHistogram copyCorrectedForCoordinatedOmission(long var1);

    public void copyInto(AbstractHistogram targetHistogram) {
        targetHistogram.reset();
        targetHistogram.add(this);
        targetHistogram.setStartTimeStamp(this.startTimeStampMsec);
        targetHistogram.setEndTimeStamp(this.endTimeStampMsec);
    }

    public void copyIntoCorrectedForCoordinatedOmission(AbstractHistogram targetHistogram, long expectedIntervalBetweenValueSamples) {
        targetHistogram.reset();
        targetHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        targetHistogram.setStartTimeStamp(this.startTimeStampMsec);
        targetHistogram.setEndTimeStamp(this.endTimeStampMsec);
    }

    public void add(AbstractHistogram fromHistogram) throws ArrayIndexOutOfBoundsException {
        if (this.highestTrackableValue < fromHistogram.highestTrackableValue) {
            throw new ArrayIndexOutOfBoundsException("The other histogram covers a wider range than this one.");
        }
        if (this.bucketCount == fromHistogram.bucketCount && this.subBucketCount == fromHistogram.subBucketCount && this.unitMagnitude == fromHistogram.unitMagnitude) {
            for (int i = 0; i < fromHistogram.countsArrayLength; ++i) {
                this.addToCountAtIndex(i, fromHistogram.getCountAtIndex(i));
            }
            this.setTotalCount(this.getTotalCount() + fromHistogram.getTotalCount());
        } else {
            for (int i = 0; i < fromHistogram.countsArrayLength; ++i) {
                long count = fromHistogram.getCountAtIndex(i);
                this.recordValueWithCount(fromHistogram.valueFromIndex(i), count);
            }
        }
    }

    public void addWhileCorrectingForCoordinatedOmission(AbstractHistogram fromHistogram, long expectedIntervalBetweenValueSamples) {
        AbstractHistogram toHistogram = this;
        for (HistogramIterationValue v : fromHistogram.recordedValues()) {
            toHistogram.recordValueWithCountAndExpectedInterval(v.getValueIteratedTo(), v.getCountAtValueIteratedTo(), expectedIntervalBetweenValueSamples);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractHistogram)) {
            return false;
        }
        AbstractHistogram that = (AbstractHistogram)other;
        if (this.lowestTrackableValue != that.lowestTrackableValue || this.highestTrackableValue != that.highestTrackableValue || this.numberOfSignificantValueDigits != that.numberOfSignificantValueDigits) {
            return false;
        }
        if (this.countsArrayLength != that.countsArrayLength) {
            return false;
        }
        if (this.getTotalCount() != that.getTotalCount()) {
            return false;
        }
        for (int i = 0; i < this.countsArrayLength; ++i) {
            if (this.getCountAtIndex(i) == that.getCountAtIndex(i)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public HistogramData getHistogramData() {
        return this.histogramData;
    }

    public long getLowestTrackableValue() {
        return this.lowestTrackableValue;
    }

    public long getHighestTrackableValue() {
        return this.highestTrackableValue;
    }

    public int getNumberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    public long sizeOfEquivalentValueRange(long value) {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        long distanceToNextValue = 1 << this.unitMagnitude + (subBucketIndex >= this.subBucketCount ? bucketIndex + 1 : bucketIndex);
        return distanceToNextValue;
    }

    public long lowestEquivalentValue(long value) {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        long thisValueBaseLevel = this.valueFromIndex(bucketIndex, subBucketIndex);
        return thisValueBaseLevel;
    }

    public long highestEquivalentValue(long value) {
        return this.nextNonEquivalentValue(value) - 1L;
    }

    public long medianEquivalentValue(long value) {
        return this.lowestEquivalentValue(value) + (this.sizeOfEquivalentValueRange(value) >> 1);
    }

    public long nextNonEquivalentValue(long value) {
        return this.lowestEquivalentValue(value) + this.sizeOfEquivalentValueRange(value);
    }

    public boolean valuesAreEquivalent(long value1, long value2) {
        return this.lowestEquivalentValue(value1) == this.lowestEquivalentValue(value2);
    }

    public int getEstimatedFootprintInBytes() {
        return this._getEstimatedFootprintInBytes();
    }

    public long getStartTimeStamp() {
        return this.startTimeStampMsec;
    }

    public void setStartTimeStamp(long timeStampMsec) {
        this.startTimeStampMsec = timeStampMsec;
    }

    public long getEndTimeStamp() {
        return this.endTimeStampMsec;
    }

    public void setEndTimeStamp(long timeStampMsec) {
        this.endTimeStampMsec = timeStampMsec;
    }

    public long getMinValue() {
        this.recordedValuesIterator.reset();
        long min = 0L;
        if (this.recordedValuesIterator.hasNext()) {
            HistogramIterationValue iterationValue = this.recordedValuesIterator.next();
            min = iterationValue.getValueIteratedTo();
        }
        return this.lowestEquivalentValue(min);
    }

    public long getMaxValue() {
        this.recordedValuesIterator.reset();
        long max = 0L;
        while (this.recordedValuesIterator.hasNext()) {
            HistogramIterationValue iterationValue = this.recordedValuesIterator.next();
            max = iterationValue.getValueIteratedTo();
        }
        return this.lowestEquivalentValue(max);
    }

    public double getMean() {
        this.recordedValuesIterator.reset();
        long totalValue = 0L;
        while (this.recordedValuesIterator.hasNext()) {
            HistogramIterationValue iterationValue = this.recordedValuesIterator.next();
            totalValue = iterationValue.getTotalValueToThisValue();
        }
        return (double)totalValue * 1.0 / (double)this.getTotalCount();
    }

    public double getStdDeviation() {
        double mean = this.getMean();
        double geometric_deviation_total = 0.0;
        this.recordedValuesIterator.reset();
        while (this.recordedValuesIterator.hasNext()) {
            HistogramIterationValue iterationValue = this.recordedValuesIterator.next();
            Double deviation = (double)this.medianEquivalentValue(iterationValue.getValueIteratedTo()) * 1.0 - mean;
            geometric_deviation_total += deviation * deviation * (double)iterationValue.getCountAddedInThisIterationStep();
        }
        double std_deviation = Math.sqrt(geometric_deviation_total / (double)this.getTotalCount());
        return std_deviation;
    }

    public long getValueAtPercentile(double percentile) {
        double requestedPercentile = Math.min(percentile, 100.0);
        long countAtPercentile = (long)(requestedPercentile / 100.0 * (double)this.getTotalCount() + 0.5);
        countAtPercentile = Math.max(countAtPercentile, 1L);
        long totalToCurrentIJ = 0L;
        for (int i = 0; i < this.bucketCount; ++i) {
            int j;
            int n = j = i == 0 ? 0 : this.subBucketCount / 2;
            while (j < this.subBucketCount) {
                if ((totalToCurrentIJ += this.getCountAt(i, j)) >= countAtPercentile) {
                    long valueAtIndex = this.valueFromIndex(i, j);
                    return valueAtIndex;
                }
                ++j;
            }
        }
        throw new ArrayIndexOutOfBoundsException("percentile value not found in range");
    }

    public double getPercentileAtOrBelowValue(long value) {
        long totalToCurrentIJ = 0L;
        int targetBucketIndex = this.getBucketIndex(value);
        int targetSubBucketIndex = this.getSubBucketIndex(value, targetBucketIndex);
        if (targetBucketIndex >= this.bucketCount) {
            return 100.0;
        }
        for (int i = 0; i <= targetBucketIndex; ++i) {
            int subBucketCap;
            int n = subBucketCap = i == targetBucketIndex ? targetSubBucketIndex + 1 : this.subBucketCount;
            for (int j = i == 0 ? 0 : this.subBucketCount / 2; j < subBucketCap; ++j) {
                totalToCurrentIJ += this.getCountAt(i, j);
            }
        }
        return 100.0 * (double)totalToCurrentIJ / (double)this.getTotalCount();
    }

    public long getCountBetweenValues(long lowValue, long highValue) throws ArrayIndexOutOfBoundsException {
        long count = 0L;
        int lowBucketIndex = this.getBucketIndex(lowValue);
        int lowSubBucketIndex = this.getSubBucketIndex(lowValue, lowBucketIndex);
        long valueAtlowValue = this.valueFromIndex(lowBucketIndex, lowSubBucketIndex);
        int highBucketIndex = this.getBucketIndex(highValue);
        int highSubBucketIndex = this.getSubBucketIndex(highValue, highBucketIndex);
        long valueAtHighValue = this.valueFromIndex(highBucketIndex, highSubBucketIndex);
        if (lowBucketIndex >= this.bucketCount || highBucketIndex >= this.bucketCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = lowBucketIndex; i <= highBucketIndex; ++i) {
            int j;
            int n = j = i == 0 ? 0 : this.subBucketCount / 2;
            while (j < this.subBucketCount) {
                long valueAtIndex = this.valueFromIndex(i, j);
                if (valueAtIndex > valueAtHighValue) {
                    return count;
                }
                if (valueAtIndex >= valueAtlowValue) {
                    count += this.getCountAt(i, j);
                }
                ++j;
            }
        }
        return count;
    }

    public long getCountAtValue(long value) throws ArrayIndexOutOfBoundsException {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        return this.getCountAt(bucketIndex, subBucketIndex);
    }

    public Percentiles percentiles(int percentileTicksPerHalfDistance) {
        return new Percentiles(this, percentileTicksPerHalfDistance);
    }

    public LinearBucketValues linearBucketValues(int valueUnitsPerBucket) {
        return new LinearBucketValues(this, valueUnitsPerBucket);
    }

    public LogarithmicBucketValues logarithmicBucketValues(int valueUnitsInFirstBucket, double logBase) {
        return new LogarithmicBucketValues(this, valueUnitsInFirstBucket, logBase);
    }

    public RecordedValues recordedValues() {
        return new RecordedValues(this);
    }

    public AllValues allValues() {
        return new AllValues(this);
    }

    public void outputPercentileDistribution(PrintStream printStream, Double outputValueUnitScalingRatio) {
        this.outputPercentileDistribution(printStream, 5, outputValueUnitScalingRatio);
    }

    public void outputPercentileDistribution(PrintStream printStream, int percentileTicksPerHalfDistance, Double outputValueUnitScalingRatio) {
        this.outputPercentileDistribution(printStream, percentileTicksPerHalfDistance, outputValueUnitScalingRatio, false);
    }

    public void outputPercentileDistribution(PrintStream printStream, int percentileTicksPerHalfDistance, Double outputValueUnitScalingRatio, boolean useCsvFormat) {
        String lastLinePercentileFormatString;
        String percentileFormatString;
        if (useCsvFormat) {
            printStream.format("\"Value\",\"Percentile\",\"TotalCount\",\"1/(1-Percentile)\"\n", new Object[0]);
        } else {
            printStream.format("%12s %14s %10s %14s\n\n", "Value", "Percentile", "TotalCount", "1/(1-Percentile)");
        }
        PercentileIterator iterator = this.percentileIterator;
        iterator.reset(percentileTicksPerHalfDistance);
        if (useCsvFormat) {
            percentileFormatString = "%." + this.numberOfSignificantValueDigits + "f,%.12f,%d,%.2f\n";
            lastLinePercentileFormatString = "%." + this.numberOfSignificantValueDigits + "f,%.12f,%d,Infinity\n";
        } else {
            percentileFormatString = "%12." + this.numberOfSignificantValueDigits + "f %2.12f %10d %14.2f\n";
            lastLinePercentileFormatString = "%12." + this.numberOfSignificantValueDigits + "f %2.12f %10d\n";
        }
        try {
            while (iterator.hasNext()) {
                HistogramIterationValue iterationValue = iterator.next();
                if (iterationValue.getPercentileLevelIteratedTo() != 100.0) {
                    printStream.format(Locale.US, percentileFormatString, (double)iterationValue.getValueIteratedTo() / outputValueUnitScalingRatio, iterationValue.getPercentileLevelIteratedTo() / 100.0, iterationValue.getTotalCountToThisValue(), 1.0 / (1.0 - iterationValue.getPercentileLevelIteratedTo() / 100.0));
                    continue;
                }
                printStream.format(Locale.US, lastLinePercentileFormatString, (double)iterationValue.getValueIteratedTo() / outputValueUnitScalingRatio, iterationValue.getPercentileLevelIteratedTo() / 100.0, iterationValue.getTotalCountToThisValue());
            }
            if (!useCsvFormat) {
                double mean = this.getMean() / outputValueUnitScalingRatio;
                double std_deviation = this.getStdDeviation() / outputValueUnitScalingRatio;
                printStream.format(Locale.US, "#[Mean    = %12." + this.numberOfSignificantValueDigits + "f, StdDeviation   = %12." + this.numberOfSignificantValueDigits + "f]\n", mean, std_deviation);
                printStream.format(Locale.US, "#[Max     = %12." + this.numberOfSignificantValueDigits + "f, Total count    = %12d]\n", (double)this.getMaxValue() / outputValueUnitScalingRatio, this.getTotalCount());
                printStream.format(Locale.US, "#[Buckets = %12d, SubBuckets     = %12d]\n", this.bucketCount, this.subBucketCount);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (this.hasOverflowed()) {
                printStream.format(Locale.US, "# Histogram counts indicate OVERFLOW values", new Object[0]);
            }
            throw e;
        }
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        o.writeLong(this.lowestTrackableValue);
        o.writeLong(this.highestTrackableValue);
        o.writeInt(this.numberOfSignificantValueDigits);
        o.writeLong(this.getTotalCount());
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        long lowestTrackableValue = o.readLong();
        long highestTrackableValue = o.readLong();
        int numberOfSignificantValueDigits = o.readInt();
        long totalCount = o.readLong();
        this.init(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits, totalCount);
        this.setTotalCount(totalCount);
    }

    public int getNeededByteBufferCapacity() {
        return this.getNeededByteBufferCapacity(this.countsArrayLength);
    }

    private int getNeededByteBufferCapacity(int relevantLength) {
        return relevantLength * this.wordSizeInBytes + 32;
    }

    abstract void fillCountsArrayFromBuffer(ByteBuffer var1, int var2);

    abstract void fillBufferFromCountsArray(ByteBuffer var1, int var2);

    private int getEncodingCookie() {
        return 478450440 + (this.wordSizeInBytes << 4);
    }

    private int getCompressedEncodingCookie() {
        return 478450441 + (this.wordSizeInBytes << 4);
    }

    private static int getCookieBase(int cookie) {
        return cookie & 0xFFFFFF0F;
    }

    private static int getWordSizeInBytesFromCookie(int cookie) {
        return (cookie & 0xF0) >> 4;
    }

    public synchronized int encodeIntoByteBuffer(ByteBuffer buffer) {
        long maxValue = this.getMaxValue();
        int relevantLength = this.getLengthForNumberOfBuckets(this.getBucketsNeededToCoverValue(maxValue));
        if (buffer.capacity() < this.getNeededByteBufferCapacity(relevantLength)) {
            throw new ArrayIndexOutOfBoundsException("buffer does not have capacity for" + this.getNeededByteBufferCapacity(relevantLength) + " bytes");
        }
        buffer.putInt(this.getEncodingCookie());
        buffer.putInt(this.numberOfSignificantValueDigits);
        buffer.putLong(this.lowestTrackableValue);
        buffer.putLong(this.highestTrackableValue);
        buffer.putLong(this.getTotalCount());
        this.fillBufferFromCountsArray(buffer, relevantLength);
        return this.getNeededByteBufferCapacity(relevantLength);
    }

    public synchronized int encodeIntoCompressedByteBuffer(ByteBuffer targetBuffer, int compressionLevel) {
        if (this.intermediateUncompressedByteBuffer == null) {
            this.intermediateUncompressedByteBuffer = ByteBuffer.allocate(this.getNeededByteBufferCapacity(this.countsArrayLength));
        }
        this.intermediateUncompressedByteBuffer.clear();
        int uncompressedLength = this.encodeIntoByteBuffer(this.intermediateUncompressedByteBuffer);
        targetBuffer.putInt(this.getCompressedEncodingCookie());
        targetBuffer.putInt(0);
        Deflater compressor = new Deflater(compressionLevel);
        compressor.setInput(this.intermediateUncompressedByteBuffer.array(), 0, uncompressedLength);
        compressor.finish();
        byte[] targetArray = targetBuffer.array();
        int compressedDataLength = compressor.deflate(targetArray, 8, targetArray.length - 8);
        compressor.end();
        targetBuffer.putInt(4, compressedDataLength);
        return compressedDataLength + 8;
    }

    public int encodeIntoCompressedByteBuffer(ByteBuffer targetBuffer) {
        return this.encodeIntoCompressedByteBuffer(targetBuffer, -1);
    }

    static AbstractHistogram constructHistogramFromBufferHeader(ByteBuffer buffer, Class histogramClass, long minBarForHighestTrackableValue) {
        int cookie = buffer.getInt();
        if (AbstractHistogram.getCookieBase(cookie) != 478450440) {
            throw new IllegalArgumentException("The buffer does not contain a Histogram");
        }
        int numberOfSignificantValueDigits = buffer.getInt();
        long lowestTrackableValue = buffer.getLong();
        long highestTrackableValue = buffer.getLong();
        long totalCount = buffer.getLong();
        highestTrackableValue = Math.max(highestTrackableValue, minBarForHighestTrackableValue);
        try {
            Constructor constructor = histogramClass.getConstructor(constructorArgsTypes);
            AbstractHistogram histogram = (AbstractHistogram)constructor.newInstance(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits);
            histogram.setTotalCount(totalCount);
            if (cookie != histogram.getEncodingCookie()) {
                throw new IllegalArgumentException("The buffer's encoded value byte size (" + AbstractHistogram.getWordSizeInBytesFromCookie(cookie) + ") does not match the Histogram's (" + histogram.wordSizeInBytes + ")");
            }
            return histogram;
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static AbstractHistogram decodeFromByteBuffer(ByteBuffer buffer, Class histogramClass, long minBarForHighestTrackableValue) {
        AbstractHistogram histogram = AbstractHistogram.constructHistogramFromBufferHeader(buffer, histogramClass, minBarForHighestTrackableValue);
        int expectedCapacity = histogram.getNeededByteBufferCapacity(histogram.countsArrayLength);
        if (expectedCapacity > buffer.capacity()) {
            throw new IllegalArgumentException("The buffer does not contain the full Histogram");
        }
        histogram.fillCountsArrayFromBuffer(buffer, histogram.countsArrayLength);
        return histogram;
    }

    static AbstractHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, Class histogramClass, long minBarForHighestTrackableValue) throws DataFormatException {
        int cookie = buffer.getInt();
        if (AbstractHistogram.getCookieBase(cookie) != 478450441) {
            throw new IllegalArgumentException("The buffer does not contain a compressed Histogram");
        }
        int lengthOfCompressedContents = buffer.getInt();
        Inflater decompressor = new Inflater();
        decompressor.setInput(buffer.array(), 8, lengthOfCompressedContents);
        ByteBuffer headerBuffer = ByteBuffer.allocate(32);
        decompressor.inflate(headerBuffer.array());
        AbstractHistogram histogram = AbstractHistogram.constructHistogramFromBufferHeader(headerBuffer, histogramClass, minBarForHighestTrackableValue);
        ByteBuffer countsBuffer = ByteBuffer.allocate(histogram.getNeededByteBufferCapacity(histogram.countsArrayLength) - 32);
        decompressor.inflate(countsBuffer.array());
        histogram.fillCountsArrayFromBuffer(countsBuffer, histogram.countsArrayLength);
        return histogram;
    }

    public boolean hasOverflowed() {
        long totalCounted = 0L;
        for (int i = 0; i < this.countsArrayLength; ++i) {
            totalCounted += this.getCountAtIndex(i);
        }
        return totalCounted != this.getTotalCount();
    }

    public void reestablishTotalCount() {
        long totalCounted = 0L;
        for (int i = 0; i < this.countsArrayLength; ++i) {
            totalCounted += this.getCountAtIndex(i);
        }
        this.setTotalCount(totalCounted);
    }

    int getBucketsNeededToCoverValue(long value) {
        long trackableValue = this.subBucketCount - 1 << this.unitMagnitude;
        int bucketsNeeded = 1;
        while (trackableValue < value) {
            trackableValue <<= 1;
            ++bucketsNeeded;
        }
        return bucketsNeeded;
    }

    int getLengthForNumberOfBuckets(int numberOfBuckets) {
        int lengthNeeded = (numberOfBuckets + 1) * (this.subBucketCount / 2);
        return lengthNeeded;
    }

    private int countsArrayIndex(int bucketIndex, int subBucketIndex) {
        assert (subBucketIndex < this.subBucketCount);
        assert (bucketIndex == 0 || subBucketIndex >= this.subBucketHalfCount);
        int bucketBaseIndex = bucketIndex + 1 << this.subBucketHalfCountMagnitude;
        int offsetInBucket = subBucketIndex - this.subBucketHalfCount;
        return bucketBaseIndex + offsetInBucket;
    }

    long getCountAt(int bucketIndex, int subBucketIndex) {
        return this.getCountAtIndex(this.countsArrayIndex(bucketIndex, subBucketIndex));
    }

    int getBucketIndex(long value) {
        int pow2ceiling = 64 - Long.numberOfLeadingZeros(value | this.subBucketMask);
        return pow2ceiling - this.unitMagnitude - (this.subBucketHalfCountMagnitude + 1);
    }

    int getSubBucketIndex(long value, int bucketIndex) {
        return (int)(value >> bucketIndex + this.unitMagnitude);
    }

    final long valueFromIndex(int bucketIndex, int subBucketIndex) {
        return (long)subBucketIndex << bucketIndex + this.unitMagnitude;
    }

    final long valueFromIndex(int index) {
        int bucketIndex = (index >> this.subBucketHalfCountMagnitude) - 1;
        int subBucketIndex = (index & this.subBucketHalfCount - 1) + this.subBucketHalfCount;
        if (bucketIndex < 0) {
            subBucketIndex -= this.subBucketHalfCount;
            bucketIndex = 0;
        }
        return this.valueFromIndex(bucketIndex, subBucketIndex);
    }

    public class AllValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;

        private AllValues(AbstractHistogram histogram) {
            this.histogram = histogram;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new AllValuesIterator(this.histogram);
        }
    }

    public class RecordedValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;

        private RecordedValues(AbstractHistogram histogram) {
            this.histogram = histogram;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new RecordedValuesIterator(this.histogram);
        }
    }

    public class LogarithmicBucketValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;
        final int valueUnitsInFirstBucket;
        final double logBase;

        private LogarithmicBucketValues(AbstractHistogram histogram, int valueUnitsInFirstBucket, double logBase) {
            this.histogram = histogram;
            this.valueUnitsInFirstBucket = valueUnitsInFirstBucket;
            this.logBase = logBase;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new LogarithmicIterator(this.histogram, this.valueUnitsInFirstBucket, this.logBase);
        }
    }

    public class LinearBucketValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;
        final int valueUnitsPerBucket;

        private LinearBucketValues(AbstractHistogram histogram, int valueUnitsPerBucket) {
            this.histogram = histogram;
            this.valueUnitsPerBucket = valueUnitsPerBucket;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new LinearIterator(this.histogram, this.valueUnitsPerBucket);
        }
    }

    public class Percentiles
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;
        final int percentileTicksPerHalfDistance;

        private Percentiles(AbstractHistogram histogram, int percentileTicksPerHalfDistance) {
            this.histogram = histogram;
            this.percentileTicksPerHalfDistance = percentileTicksPerHalfDistance;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new PercentileIterator(this.histogram, this.percentileTicksPerHalfDistance);
        }
    }
}

