/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "wae" locale.
 */
public class LocalizedNamesImpl_wae extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "DZ",
        "US",
        "VI",
        "UM",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AZ",
        "AU",
        "BH",
        "BS",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BQ",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "MM",
        "BI",
        "EA",
        "CN",
        "CP",
        "CK",
        "CR",
        "CW",
        "DK",
        "DG",
        "DO",
        "DM",
        "DJ",
        "EC",
        "EG",
        "CI",
        "SV",
        "GB",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EU",
        "EZ",
        "FK",
        "FO",
        "FJ",
        "FI",
        "FR",
        "GF",
        "TF",
        "PF",
        "GA",
        "GM",
        "GH",
        "GE",
        "GI",
        "GN",
        "GW",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GY",
        "HT",
        "HM",
        "AC",
        "NL",
        "HN",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IM",
        "IL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "KZ",
        "QA",
        "KE",
        "KG",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "HR",
        "CU",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LI",
        "LT",
        "LY",
        "LU",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MR",
        "MU",
        "MK",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "ME",
        "MZ",
        "YT",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NC",
        "NZ",
        "KP",
        "MP",
        "NF",
        "NO",
        "OM",
        "AT",
        "TL",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PT",
        "PR",
        "RE",
        "RW",
        "RO",
        "RU",
        "SB",
        "ZM",
        "WS",
        "SM",
        "ST",
        "SA",
        "ES",
        "SE",
        "CH",
        "SC",
        "SN",
        "RS",
        "SL",
        "ZW",
        "SG",
        "SK",
        "SI",
        "SO",
        "HK",
        "MO",
        "LK",
        "SS",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "ZA",
        "SD",
        "GS",
        "KR",
        "SY",
        "SR",
        "SJ",
        "SZ",
        "SX",
        "TJ",
        "TW",
        "TZ",
        "TH",
        "DE",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TD",
        "CZ",
        "CL",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UG",
        "UA",
        "UN",
        "HU",
        "UY",
        "UZ",
        "QO",
        "VU",
        "VA",
        "VE",
        "AE",
        "VN",
        "WF",
        "EH",
        "CX",
        "BY",
        "XA",
        "XB",
        "XK",
        "CF",
        "CY",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Wäld");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Nordamerika");
    namesMap.put("005", "Südamerika");
    namesMap.put("009", "Ozeanie");
    namesMap.put("011", "Weštafrika");
    namesMap.put("013", "Zentralamerika");
    namesMap.put("014", "Oštafrika");
    namesMap.put("015", "Nordafrika");
    namesMap.put("017", "Mittelafrika");
    namesMap.put("018", "Südličs Afrika");
    namesMap.put("019", "Amerikaniš Kontinänt");
    namesMap.put("021", "Nördličs Amerika");
    namesMap.put("029", "Karibik");
    namesMap.put("030", "Oštasie");
    namesMap.put("034", "Südasie");
    namesMap.put("035", "Südoštasie");
    namesMap.put("039", "Südeuropa");
    namesMap.put("053", "Auštralie und Niwséland");
    namesMap.put("054", "Melanesie");
    namesMap.put("057", "Mikronesišes Inselgebiet");
    namesMap.put("061", "Polinesie");
    namesMap.put("142", "Asie");
    namesMap.put("143", "Zentralasie");
    namesMap.put("145", "Weštasie");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Ošteuropa");
    namesMap.put("154", "Nordeuropa");
    namesMap.put("155", "Wešteuropa");
    namesMap.put("419", "Latíamerika");
    namesMap.put("AC", "Himmelfártsinsla");
    namesMap.put("AE", "Vereinigti Arabiše Emirat");
    namesMap.put("AF", "Afganištan");
    namesMap.put("AG", "Antigua und Barbuda");
    namesMap.put("AL", "Albanie");
    namesMap.put("AM", "Armenie");
    namesMap.put("AQ", "Antarktis");
    namesMap.put("AR", "Argentinie");
    namesMap.put("AS", "Amerikaniš Samoa");
    namesMap.put("AT", "Öštrič");
    namesMap.put("AU", "Australie");
    namesMap.put("AX", "Alandinslä");
    namesMap.put("AZ", "Aserbaidšan");
    namesMap.put("BA", "Bosnie und Herzegovina");
    namesMap.put("BD", "Bangladeš");
    namesMap.put("BE", "Belgie");
    namesMap.put("BG", "Bulgarie");
    namesMap.put("BH", "Bačrain");
    namesMap.put("BL", "St. Bartholomäus-Insla");
    namesMap.put("BO", "Boliwie");
    namesMap.put("BR", "Brasilie");
    namesMap.put("BV", "Bouvetinsla");
    namesMap.put("BY", "Wísrussland");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokosinslä");
    namesMap.put("CD", "Kongo-Kinshasa");
    namesMap.put("CF", "Zentralafrikaniši Rebublik");
    namesMap.put("CG", "Kongo Brazzaville");
    namesMap.put("CH", "Schwiz");
    namesMap.put("CI", "Elfebeiküšta");
    namesMap.put("CK", "Cookinslä");
    namesMap.put("CL", "Tšile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CO", "Kolumbie");
    namesMap.put("CP", "Clipperton Insla");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kap Verde");
    namesMap.put("CX", "Wienäčtsinslä");
    namesMap.put("CY", "Zypre");
    namesMap.put("CZ", "Tšečie");
    namesMap.put("DE", "Titšland");
    namesMap.put("DJ", "Dšibuti");
    namesMap.put("DK", "Dänemark");
    namesMap.put("DM", "Doninica");
    namesMap.put("DO", "Dominikaniši Rebublik");
    namesMap.put("DZ", "Algerie");
    namesMap.put("EA", "Ceuta und Melilla");
    namesMap.put("EE", "Eštland");
    namesMap.put("EG", "Egypte");
    namesMap.put("EH", "Weštsahara");
    namesMap.put("ES", "Schpanie");
    namesMap.put("ET", "Ethiopie");
    namesMap.put("EU", "Europäiši Unio");
    namesMap.put("FI", "Finnland");
    namesMap.put("FJ", "Fidši");
    namesMap.put("FK", "Falklandinslä");
    namesMap.put("FM", "Mikronesie");
    namesMap.put("FO", "Färöe");
    namesMap.put("FR", "Frankrič");
    namesMap.put("GB", "England");
    namesMap.put("GE", "Georgie");
    namesMap.put("GF", "Französiš Guiana");
    namesMap.put("GH", "Gana");
    namesMap.put("GL", "Grönland");
    namesMap.put("GN", "Ginea");
    namesMap.put("GQ", "Equatorialginea");
    namesMap.put("GR", "Gričeland");
    namesMap.put("GS", "Südgeorgie und d’südliče Senwičinslä");
    namesMap.put("GW", "Ginea Bissau");
    namesMap.put("HK", "Sonderverwaltigszona Hongkong");
    namesMap.put("HM", "Heard- und McDonald-Inslä");
    namesMap.put("HR", "Kroatie");
    namesMap.put("HU", "Ungare");
    namesMap.put("IC", "Kanariše Inslä");
    namesMap.put("ID", "Indonesie");
    namesMap.put("IE", "Irland");
    namesMap.put("IN", "Indie");
    namesMap.put("IO", "Britišes Territorium em indiše Ozean");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Italie");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jordanie");
    namesMap.put("KG", "Kirgištan");
    namesMap.put("KH", "Kambodša");
    namesMap.put("KM", "Komore");
    namesMap.put("KN", "St. Kitts und Nevis");
    namesMap.put("KP", "Nordkorea");
    namesMap.put("KR", "Südkorea");
    namesMap.put("KW", "Kuweit");
    namesMap.put("KY", "Kaimaninslä");
    namesMap.put("KZ", "Kasačstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LI", "Liečteštei");
    namesMap.put("LT", "Litaue");
    namesMap.put("LU", "Luxeburg");
    namesMap.put("LV", "Lettland");
    namesMap.put("LY", "Lübie");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monago");
    namesMap.put("MD", "Moldau");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Maršalinslä");
    namesMap.put("MK", "Mazedonie");
    namesMap.put("MM", "Burma");
    namesMap.put("MN", "Mongolei");
    namesMap.put("MO", "Sonderverwaltigszona Makau");
    namesMap.put("MP", "Nördliči Mariane");
    namesMap.put("MR", "Mauretanie");
    namesMap.put("MS", "Monserrat");
    namesMap.put("MV", "Malediwe");
    namesMap.put("MX", "Mexiko");
    namesMap.put("MZ", "Mosambik");
    namesMap.put("NC", "Niwkaledonie");
    namesMap.put("NF", "Norfolkinsla");
    namesMap.put("NL", "Holand");
    namesMap.put("NO", "Norwäge");
    namesMap.put("NZ", "Niwséland");
    namesMap.put("PF", "Französiš Polinesie");
    namesMap.put("PG", "Papua Niwginea");
    namesMap.put("PH", "Philippine");
    namesMap.put("PK", "Pakištan");
    namesMap.put("PL", "Pole");
    namesMap.put("PM", "St. Pierre und Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Paleština");
    namesMap.put("PY", "Paraguai");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Üssers Ozeanie");
    namesMap.put("RO", "Rumänie");
    namesMap.put("RS", "Serbie");
    namesMap.put("RU", "Russland");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudi Arabie");
    namesMap.put("SB", "Salomone");
    namesMap.put("SC", "Sečelle");
    namesMap.put("SE", "Schwede");
    namesMap.put("SG", "Singapur");
    namesMap.put("SI", "Slowenie");
    namesMap.put("SJ", "Svalbard und Jan Mayen");
    namesMap.put("SK", "Slowakei");
    namesMap.put("ST", "São Tomé and Príncipe");
    namesMap.put("SY", "Sürie");
    namesMap.put("SZ", "Swasiland");
    namesMap.put("TC", "Turks- und Caicosinslä");
    namesMap.put("TD", "Tšad");
    namesMap.put("TF", "Französiši Süd- und Antarktisgebiet");
    namesMap.put("TJ", "Tadšikistan");
    namesMap.put("TL", "Ošttimor");
    namesMap.put("TM", "Turkmeništan");
    namesMap.put("TN", "Tunesie");
    namesMap.put("TR", "Türkei");
    namesMap.put("TT", "Trinidad und Tobago");
    namesMap.put("TZ", "Tansania");
    namesMap.put("UM", "Amerikaniš Ozeanie");
    namesMap.put("US", "Amerika");
    namesMap.put("UY", "Urugauy");
    namesMap.put("UZ", "Usbekištan");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "St. Vincent und d’Grenadine");
    namesMap.put("VG", "Britiši Jungfröiwinslä");
    namesMap.put("VI", "Amerikaniši Jungfröiwinslä");
    namesMap.put("WF", "Wallis und Futuna");
    namesMap.put("YE", "Jéme");
    namesMap.put("YT", "Moyette");
    namesMap.put("ZA", "Südafrika");
    namesMap.put("ZM", "Sambia");
    namesMap.put("ZW", "Simbabwe");
    namesMap.put("ZZ", "Unbekannti Regio");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Wäld",
        "002": "Afrika",
        "003": "Nordamerika",
        "005": "Südamerika",
        "009": "Ozeanie",
        "011": "Weštafrika",
        "013": "Zentralamerika",
        "014": "Oštafrika",
        "015": "Nordafrika",
        "017": "Mittelafrika",
        "018": "Südličs Afrika",
        "019": "Amerikaniš Kontinänt",
        "021": "Nördličs Amerika",
        "029": "Karibik",
        "030": "Oštasie",
        "034": "Südasie",
        "035": "Südoštasie",
        "039": "Südeuropa",
        "053": "Auštralie und Niwséland",
        "054": "Melanesie",
        "057": "Mikronesišes Inselgebiet",
        "061": "Polinesie",
        "142": "Asie",
        "143": "Zentralasie",
        "145": "Weštasie",
        "150": "Europa",
        "151": "Ošteuropa",
        "154": "Nordeuropa",
        "155": "Wešteuropa",
        "419": "Latíamerika",
        "AC": "Himmelfártsinsla",
        "AE": "Vereinigti Arabiše Emirat",
        "AF": "Afganištan",
        "AG": "Antigua und Barbuda",
        "AL": "Albanie",
        "AM": "Armenie",
        "AQ": "Antarktis",
        "AR": "Argentinie",
        "AS": "Amerikaniš Samoa",
        "AT": "Öštrič",
        "AU": "Australie",
        "AX": "Alandinslä",
        "AZ": "Aserbaidšan",
        "BA": "Bosnie und Herzegovina",
        "BD": "Bangladeš",
        "BE": "Belgie",
        "BG": "Bulgarie",
        "BH": "Bačrain",
        "BL": "St. Bartholomäus-Insla",
        "BO": "Boliwie",
        "BR": "Brasilie",
        "BV": "Bouvetinsla",
        "BY": "Wísrussland",
        "CA": "Kanada",
        "CC": "Kokosinslä",
        "CD": "Kongo-Kinshasa",
        "CF": "Zentralafrikaniši Rebublik",
        "CG": "Kongo Brazzaville",
        "CH": "Schwiz",
        "CI": "Elfebeiküšta",
        "CK": "Cookinslä",
        "CL": "Tšile",
        "CM": "Kamerun",
        "CO": "Kolumbie",
        "CP": "Clipperton Insla",
        "CU": "Kuba",
        "CV": "Kap Verde",
        "CX": "Wienäčtsinslä",
        "CY": "Zypre",
        "CZ": "Tšečie",
        "DE": "Titšland",
        "DJ": "Dšibuti",
        "DK": "Dänemark",
        "DM": "Doninica",
        "DO": "Dominikaniši Rebublik",
        "DZ": "Algerie",
        "EA": "Ceuta und Melilla",
        "EE": "Eštland",
        "EG": "Egypte",
        "EH": "Weštsahara",
        "ES": "Schpanie",
        "ET": "Ethiopie",
        "EU": "Europäiši Unio",
        "FI": "Finnland",
        "FJ": "Fidši",
        "FK": "Falklandinslä",
        "FM": "Mikronesie",
        "FO": "Färöe",
        "FR": "Frankrič",
        "GB": "England",
        "GE": "Georgie",
        "GF": "Französiš Guiana",
        "GH": "Gana",
        "GL": "Grönland",
        "GN": "Ginea",
        "GQ": "Equatorialginea",
        "GR": "Gričeland",
        "GS": "Südgeorgie und d’südliče Senwičinslä",
        "GW": "Ginea Bissau",
        "HK": "Sonderverwaltigszona Hongkong",
        "HM": "Heard- und McDonald-Inslä",
        "HR": "Kroatie",
        "HU": "Ungare",
        "IC": "Kanariše Inslä",
        "ID": "Indonesie",
        "IE": "Irland",
        "IN": "Indie",
        "IO": "Britišes Territorium em indiše Ozean",
        "IQ": "Irak",
        "IS": "Island",
        "IT": "Italie",
        "JM": "Jamaika",
        "JO": "Jordanie",
        "KG": "Kirgištan",
        "KH": "Kambodša",
        "KM": "Komore",
        "KN": "St. Kitts und Nevis",
        "KP": "Nordkorea",
        "KR": "Südkorea",
        "KW": "Kuweit",
        "KY": "Kaimaninslä",
        "KZ": "Kasačstan",
        "LB": "Libanon",
        "LI": "Liečteštei",
        "LT": "Litaue",
        "LU": "Luxeburg",
        "LV": "Lettland",
        "LY": "Lübie",
        "MA": "Maroko",
        "MC": "Monago",
        "MD": "Moldau",
        "MG": "Madagaskar",
        "MH": "Maršalinslä",
        "MK": "Mazedonie",
        "MM": "Burma",
        "MN": "Mongolei",
        "MO": "Sonderverwaltigszona Makau",
        "MP": "Nördliči Mariane",
        "MR": "Mauretanie",
        "MS": "Monserrat",
        "MV": "Malediwe",
        "MX": "Mexiko",
        "MZ": "Mosambik",
        "NC": "Niwkaledonie",
        "NF": "Norfolkinsla",
        "NL": "Holand",
        "NO": "Norwäge",
        "NZ": "Niwséland",
        "PF": "Französiš Polinesie",
        "PG": "Papua Niwginea",
        "PH": "Philippine",
        "PK": "Pakištan",
        "PL": "Pole",
        "PM": "St. Pierre und Miquelon",
        "PN": "Pitcairn",
        "PS": "Paleština",
        "PY": "Paraguai",
        "QA": "Katar",
        "QO": "Üssers Ozeanie",
        "RO": "Rumänie",
        "RS": "Serbie",
        "RU": "Russland",
        "RW": "Ruanda",
        "SA": "Saudi Arabie",
        "SB": "Salomone",
        "SC": "Sečelle",
        "SE": "Schwede",
        "SG": "Singapur",
        "SI": "Slowenie",
        "SJ": "Svalbard und Jan Mayen",
        "SK": "Slowakei",
        "ST": "São Tomé and Príncipe",
        "SY": "Sürie",
        "SZ": "Swasiland",
        "TC": "Turks- und Caicosinslä",
        "TD": "Tšad",
        "TF": "Französiši Süd- und Antarktisgebiet",
        "TJ": "Tadšikistan",
        "TL": "Ošttimor",
        "TM": "Turkmeništan",
        "TN": "Tunesie",
        "TR": "Türkei",
        "TT": "Trinidad und Tobago",
        "TZ": "Tansania",
        "UM": "Amerikaniš Ozeanie",
        "US": "Amerika",
        "UY": "Urugauy",
        "UZ": "Usbekištan",
        "VA": "Vatikan",
        "VC": "St. Vincent und d’Grenadine",
        "VG": "Britiši Jungfröiwinslä",
        "VI": "Amerikaniši Jungfröiwinslä",
        "WF": "Wallis und Futuna",
        "YE": "Jéme",
        "YT": "Moyette",
        "ZA": "Südafrika",
        "ZM": "Sambia",
        "ZW": "Simbabwe",
        "ZZ": "Unbekannti Regio"
    };
  }-*/;
}
